% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleSim.R
\name{SimulateDropout}
\alias{SimulateDropout}
\title{Simulate subject dropout}
\usage{
SimulateDropout(simComplete, drop.mechanism)
}
\arguments{
\item{simComplete}{A \code{SingleSim} object (with \code{status="complete"})}

\item{drop.mechanism}{A \code{DropoutMechanism} object}
}
\value{
A \code{SingleSim} object with \code{status='dropout'}
}
\description{
This function takes a complete recurrent event data set
and drop out mechanism and creates a data set set with
dropout
}
\examples{
sim <- SimulateComplete(study.time=365,number.subjects=50,
                        event.rates=c(0.01,0.005),dispersions=0.25)
                        
sim.with.MCAR.dropout <- SimulateDropout(sim,
                      drop.mechanism = ConstantRateDrop(rate = 0.0025)) 
sim.with.MAR.dropout <- SimulateDropout(sim, 
                     drop.mechanism = LinearRateChangeDrop(
                                          starting.rate = 0.0025,
                                          rate.change = 0.0005))

}
