% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{calc_K}
\alias{calc_K}
\title{Calculates covariance matrix}
\usage{
calc_K(d2, theta, g = NULL)
}
\arguments{
\item{d2}{matrix of squared distances among input locations}

\item{theta}{length scale parameter determining strength of correlation}

\item{g}{nugget parameter determining noise level (only used if \code{d2} 
is square)}
}
\value{
symmetric covariance matrix
}
\description{
Calculates covariance matrix based on inverse exponentiated
    squared euclidean distance with specified hyperparameters.
}
\examples{
x <- seq(0, 1, length = 10)
K <- calc_K(sq_dist(x), theta = 0.1, g = 0.01)

}
