% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tables_vectors.R
\name{load_tables_vectors}
\alias{load_tables_vectors}
\title{Load the Input-Output and Final demand tables}
\usage{
load_tables_vectors(x, y, k, i, o, v = NULL, null_inventory = FALSE)
}
\arguments{
\item{x}{intermediate demand table, it has dimensions GN x GN (G = no. of country, N = no. of industries),
excluding the first row and the first column which contains the country names,
and the second row and second column which contain the industry names for each country.
In addition, an extra row at the end should contain final demand.}

\item{y}{final demand table it has dimensions GN x MN,
excluding the first row and the first column which contains the country names,
the second column which contains the industry names for each country,
and second row which contains the five decomposed final demands (M).
#' @param k is a vector of country of region names}

\item{k}{vector or country or region names}

\item{i}{vector of sector or industry names}

\item{o}{vector of final outputs}

\item{v}{vector of value added}

\item{null_inventory}{when the inventory (last FDC) should be set to zero}
}
\value{
a decompr class object
}
\description{
This function loads the demand tables
and defines all variables for the decomposition
}
\details{
Adapted from code by Fei Wang.
}
\examples{
# load example data
data(leather)

# create intermediate object (class decompr)
decompr_object <- load_tables_vectors(inter,
                                      final,
                                      countries,
                                      industries,
                                      out)

# examine output object                                    
str(decompr_object)
}
\author{
Bastiaan Quast
}

