% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Decode.r
\name{runDecode}
\alias{runDecode}
\title{Differential Co-Expression and Differential Expression Analysis}
\usage{
runDecode(geneSetInputFile, geneExpressionFile)
}
\arguments{
\item{geneSetInputFile}{Path for functional gene set data}

\item{geneExpressionFile}{Path for gene expression data



Input:
(1) gene expression data

(2) functional gene set data

Output: Table summary for the selected HDC-HDE gene sets, 'out_summary.txt'



Data format for gene expression data (Columns are tab-separated):


 Column 1: Official gene symbol

 Column 2: Probe ID

 Starting from column 3: Expression for different samples


 Row 1 (starting from column 3): Sample class ("1" indicates control group; "2" indicates case group)

 Row 2: Sample id

 Starting from row 3: Expression for different genes


 Example:

geneName   probeID         2       2        2        1         1         1

-            -          Case1    Case2    Case3   Control1  Control2  Control3

7A5      ILMN_1762337  5.12621  5.19419  5.06645  5.40649   5.51259   5.387

A1BG     ILMN_2055271  5.63504  5.68533  5.66251  5.37466   5.43955   5.50973

A1CF     ILMN_2383229  5.41543  5.58543  5.43239  5.49634   5.62685   5.36962

A26C3    ILMN_1653355  5.56713  5.5547   5.59547  5.46895   5.49622   5.50094

A2BP1    ILMN_1814316  5.23016  5.33808  5.31413  5.30586   5.40108   5.31855

A2M      ILMN_1745607  7.65332  6.56431  8.20163  9.19837   9.04295   10.1448

A2ML1    ILMN_2136495  5.53532  5.93801  5.33728  5.36676   5.79942   5.13974

A3GALT2  ILMN_1668111  5.18578  5.35207  5.30554  5.26107   5.26536   5.28932




Data format for functional gene set data (Columns are tab-separated):


 Column 1: Functional gene set name

 Column 2: Other description such as gene set id

 Starting from column 3: Official gene symbols for the functional gene set

 Example:

B cell activation   GO\\GO:0042113   AKAP17A   ZAP70   PFDN1 ...

apoptotic signaling pathway   GO\\GO:0097190   ITPR1   PTH   DNAJC10   HINT1 ...}
}
\description{
Given a set of gene expression data and functional gene set data, the program will return a table summary for the selected gene sets with high differential co-expression and high differential expression (HDC-HDE). User need to specify the input paths for the gene expression data and functional gene set data.
}
\details{
The main program for DECODE algorithm

To run an example using expression data with 1400 genes.

runDecode("\\extdata\\geneSet.txt","\\extdata\\Expression_data_1400genes.txt")

or

runDecode("/extdata/geneSet.txt","/extdata/Expression_data_1400genes.txt")

The sample data with 1400 genes takes 16 minutes to complete. (Computer used: An Intel Core i7-4600 processor, 2.69 GHz, 8 GB RAM)
}
\examples{
\dontrun{
path = system.file('extdata', package='decode')
geneSetInputFile = file.path(path, "geneSet.txt")
geneExpressionFile = file.path(path, "Expression_data_50genes.txt")
runDecode(geneSetInputFile, geneExpressionFile)
}
}

