% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/estimate.R
\name{row.names.estimate}
\alias{corMat.estimate}
\alias{corMat<-.estimate}
\alias{names.estimate}
\alias{row.names.estimate}
\title{Get and set attributes of an \code{estimate} object.}
\usage{
\method{row.names}{estimate}(x)

\method{names}{estimate}(x)

\method{corMat}{estimate}(rho)

\method{corMat}{estimate}(x) <- value
}
\arguments{
\item{x}{an \code{\link{estimate}} object.}

\item{rho}{an \code{\link{estimate}} object.}

\item{value}{\code{numeric matrix}: new correlation matrix. For details cf.
\code{\link{estimate}}.}
}
\description{
\code{row.names.estimate} returns the variable names of an \code{\link{estimate}} object which
is identical to \code{row.names(x$marginal)}.

\code{names.estimate} returns the column names of an \code{\link{estimate}} object which is identical to
\code{names(x$marginal)}.

\code{corMat.estimate} returns the full correlation matrix of an \code{\link{estimate}} object.

\code{'corMat<-.estimate'} replaces the correlation matrix of an \code{\link{estimate}} object.
}
\examples{
# Read the joint estimate information for the variables "sales", "productprice" and
 # "costprice" from file:
 ## Get the path to the file with the marginal information:
 marginalFilePath=system.file("extdata","profit-4.csv",package="decisionSupport")
 ## Read marginal and correlation file into an estimate:
 parameterEstimate<-estimate_read_csv(fileName=marginalFilePath)
 print(parameterEstimate)
 ## Print the names of the variables of this estimate
 print(row.names(parameterEstimate))
## Print the names of the columns of this estimate
  print(names(parameterEstimate))
## Print the full correlation matrix of this estimate
  print(corMat(parameterEstimate))
}
\seealso{
\code{\link{estimate}}, \code{\link{names.estimate}}, \code{\link{corMat.estimate}},
  \code{\link{corMat}}

\code{\link{corMat<-}}
}

