% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_MSOA_data}
\alias{get_MSOA_data}
\title{Get MSOA energy consumption data}
\usage{
get_MSOA_data(year = max(get_MSOA_years()), sector = c("domestic",
  "nondomestic"), fuel = c("electricity", "gas"), id, dir)
}
\arguments{
\item{year}{the year for which you want data.  Defaults to the most
recent year available.}

\item{sector}{the economic sector to fetch.  Valid values are
'domestic', 'nondomestic'}

\item{fuel}{the fuel type to fetch.  Valid values are
'electricity', 'gas'}

\item{id}{the unique id of the MSOA to fetch.  If not specified,
then all MSOAs are retrieved.}

\item{dir}{an optional directory in which to save a copy of the
data}
}
\value{
a long data frame with the requested data.  The 'energy'
column is measured in GWh.
}
\description{
This function fetches MSOA (Middle Super Output Area) data from the
DECC website.  Since the format of these files tends to change just
enough to be irritating for dependent code, there is also an option
that allows you to cache a local copy.
}
\examples{
\dontrun{
msoa_data <- get_MSOA_data() # Gets all data
}
}
\keyword{data}
\keyword{energy}

