% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{FuzzyExample}
\alias{FuzzyExample}
\title{Data: Fuzzy data reading example.}
\format{
Data frame with 5 rows and 15 columns.
\describe{
  \item{DMU}{DMU names}
  \item{Input1.mL}{First Input (crisp numbers)}
  \item{Input2.mL}{Second Input (left centers)}
  \item{Input2.mR}{Second Input (right centers)}
  \item{Input2.dL}{Second Input (left radii)}
  \item{Input2.dR}{Second Input (right radii)}
  \item{Input3.mL}{Third Input (centers)}
  \item{Input3.dL}{Third Input (radii)}
  \item{Output1.mL}{First Output (crisp numbers)}
  \item{Output2.mL}{Second Output (left centers)}
  \item{Output2.mR}{Second Output (right centers)}
  \item{Output2.dL}{Second Output (radii)}
  \item{Output3.mL}{Third Output (centers)}
  \item{Output3.dL}{Third Output (left radii)}
  \item{Output3.dR}{Third Output (right radii)}
}
}
\usage{
data("FuzzyExample")
}
\description{
Synthetic dataset of 5 DMUs with 3 inputs and 3 outputs containing fuzzy and
crisp data.
}
\examples{

# Example. Reading the data.
data("FuzzyExample")
datafuzzy <- read_data_fuzzy(FuzzyExample, 
                             inputs.mL = c(2, 3, 7),
                             inputs.mR = c(NA, 4, NA),
                             inputs.dL = c(NA, 5, 8),
                             inputs.dR = c(NA, 6, NA),
                             outputs.mL = c(9, 10 , 13),
                             outputs.mR = c(NA, 11, NA),
                             outputs.dL = c(NA, 12, 14),
                             outputs.dR = c(NA, NA, 15))
                                                             

}
\seealso{
\code{\link{read_data_fuzzy}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
