% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_supereff.R
\name{model_supereff}
\alias{model_supereff}
\title{Radial superefficiency basic DEA model}
\usage{
model_supereff(datadea,
            dmu_eval = NULL,
            dmu_ref = NULL,
            supereff_modelname = c("basic"),
            ...)
}
\arguments{
\item{datadea}{The data, including DMUs, inputs and outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.}

\item{supereff_modelname}{A string containing the name of the radial model to apply superefficiency.}

\item{...}{\code{orientation}, \code{rts} and other model parameters.}
}
\description{
Solve Andersen and Petersen radial Super-efficiency DEA model.
}
\note{
(1) Radial super-efficiency model under variable (vrs, nirs, ndrs, grs) returns to scale can be infeasible for certain DMUs. See example 2.

(2) DMUs with infeasible solution are not shown in the results.
}
\examples{
# Example 1.
# Replication of results in Tone (2002, p.38)
data("Power_plants")
data_example <- read_data(Power_plants, 
                          ni = 4, 
                          no = 2)
result <- model_supereff(data_example, 
                         orientation = "io", 
                         rts = "crs") 
eff <- efficiencies(result)
 
# Example 2. 
# Results of Super-efficiency with vrs returns to scale show infeasibility solutions 
# for DMUs D4 and D6 (these DMUs are not shown in deaR results).
data("Power_plants")
data_example2 <- read_data(Power_plants, 
                           ni = 4, 
                           no = 2) 
result2 <- model_supereff(data_example2, 
                          orientation = "io", 
                          rts = "vrs") 
eff2 <- efficiencies(result2)

}
\references{
Andersen, P.; Petersen, N.C. (1993). "A procedure for ranking efficient units in data envelopment analysis", Management Science, 39, 1261-1264. 

Tone, K. (2002). "A slacks-based measure of super-efficiency in data envelopment analysis", European Journal of Operational Research, 143, 32-41.
}
\seealso{
\code{\link{model_basic}}, \code{\link{model_sbmsupereff}}, \code{\link{model_addsupereff}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
