% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_tree_with_heatmap}
\alias{plot_tree_with_heatmap}
\title{Plot the MAP tree and class profiles (heatmap) of summarized DDT-LCM results}
\usage{
plot_tree_with_heatmap(
  tree_with_parameter,
  response_prob,
  item_membership_list
)
}
\arguments{
\item{tree_with_parameter}{a "phylo4d" tree with node parameters}

\item{response_prob}{a K by J matrix, where the k,j-th element is the response
probability of item j for individuals in class k}

\item{item_membership_list}{a list of G elements, where the g-th element contains the
column indices of the observed data matrix corresponding to items in major group g}
}
\value{
a ggplot2 object. A plot with the tree structure on the left and a heatmap
of item response probabilities on the right, with indication of item group
memberships beneath the heatmap.
}
\description{
Plot the MAP tree and class profiles (heatmap) of summarized DDT-LCM results
}
\examples{
# load the MAP tree structure obtained from the real HCHS/SOL data
data(data_synthetic)
# extract elements into the global environment
list2env(setNames(data_synthetic, names(data_synthetic)), envir = globalenv()) 
plot_tree_with_heatmap(tree_with_parameter, response_prob, item_membership_list)
}
