% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{x_var}
\alias{x_var}
\alias{x_var<-}
\alias{y_var}
\alias{y_var<-}
\title{Get/set the X/Y variable (dye name)}
\usage{
x_var(plate)

y_var(plate)

x_var(plate) <- value

y_var(plate) <- value
}
\arguments{
\item{plate}{A ddPCR plate}

\item{value}{New dye name}
}
\value{
Dye name
}
\description{
By default, the dye visualized along the X axis is HEX and the dye visualized
along the Y axis is FAM. You can use these functions to get or set these values
if your plate uses different dyes.
}
\details{
The X/Y variables are simply parameters in the plate, which can also be accessed
or changed using \code{\link[ddpcr]{params}}. You should use these functions
to change the X/Y variable rather than changing the parameters directly.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir())
x_var(plate)
x_var(plate) <- "VIC"
x_var(plate)
}
}
\seealso{
\code{\link[ddpcr]{params}}
}

