% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{reset}
\alias{reset}
\title{Reset a plate}
\usage{
reset(plate, type, params, keep_type = FALSE, keep_params = FALSE)
}
\arguments{
\item{plate}{A ddPCR plate}

\item{type}{A ddPCR plate type (see \code{\link[ddpcr]{plate_types}})}

\item{params}{List of parameters to set for the plate. Only advanced users
should consider using this feature. See \code{\link[ddpcr]{new_plate}} for usage.}

\item{keep_type}{If \code{TRUE} then use keep the same plate type as \code{plate}}

\item{keep_params}{If \code{TRUE} then keep the same plate parameters of \code{plate}}
}
\value{
A new unanalyzed ddPCR plate
}
\description{
Reset a ddPCR plate object back to its original state. After resetting a plate,
all the analysis progress will be lost, but the original droplet data and
plate metadata will be kept. Two common reasons to reset a plate are either
to restart the analysis, or to re-analyze the plate as a different plate type.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$custom_thresholds)
plate <- reset(plate, type=plate_types$fam_positive_pnpp)
} 
}
\seealso{
\code{\link[ddpcr]{plate_types}}\cr
\code{\link[ddpcr]{new_plate}}
}
