% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-hex_positive_pnpp.R
\name{hex_positive_pnpp}
\alias{hex_positive_pnpp}
\title{Plate type: HEX-positive PNPP}
\description{
A ddPCR plate of type \code{hex_positive_pnpp}, which can also be expressed as
(HEX+)/(FAM+HEX+), is a subtype of both \code{\link[ddpcr]{pnpp_experiment}}
and \code{\link[ddpcr]{wildtype_mutant_pnpp}}. Use this plate type if your data
has three main clusters of droplets: double-negative (empty droplets),
FAM+HEX+ (wildtype droplets) and HEX+FAM- (mutant droplets).
}
\details{
Plates with this type have the following analysis steps: \code{INITIALIZE},
\code{REMOVE_FAILURES}, \code{REMOVE_OUTLIERS}, \code{REMOVE_EMPTY},
\code{CLASSIFY}, \code{RECLASSIFY}.

Plates with this type have the following droplet clusters:
\code{UNDEFINED}, \code{FAILED}, \code{OUTLIER}, \code{EMPTY} (double-negative),
\code{RAIN} (not empty but not wildtype nor negative), \code{POSITIVE} (wildtype),
\code{NEGATIVE} (mutant).

\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on plate types.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$hex_positive_pnpp)
type(plate)
plate \%>\% analyze \%>\% plot
} 
}
\seealso{
\code{\link[ddpcr]{plate_types}}\cr
\code{\link[ddpcr]{wildtype_mutant_pnpp}}\cr
\code{\link[ddpcr]{fam_positive_pnpp}}\cr
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{remove_failures}}\cr
\code{\link[ddpcr]{remove_outliers}}\cr
\code{\link[ddpcr]{remove_empty}}\cr
\code{\link[ddpcr]{classify_droplets}}\cr
\code{\link[ddpcr]{reclassify_droplets}}
}

