% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{params}
\alias{params}
\alias{params<-}
\title{Plate parameters}
\usage{
params(plate, category, name)

params(plate, category, name) <- value
}
\arguments{
\item{plate}{A ddPCR plate}

\item{category}{Category of parameters}

\item{name}{Parameter name}

\item{value}{New parameter value}
}
\value{
If no category is provided, return all parameters. If a category is provided,
return all parameters in that category. If both a category and a name are provided,
return the value of the specific parameter.
}
\description{
Every ddPCR plate object has adjustable parameters associated with it.
Each parameter belongs to a category of parameters, and has a unique name.
For example, there are general parameters (category 'GENERAL') that apply to
the plate as a whole, and each analysis step has its own set of parameters
that are used for the algorithm in that step.\cr\cr
You can either view all parameters of a plate by not providing any arguments,
view all parameters in a category by providing the category, or view the value
of a specific parameter by providing both the category and the parameter name.\cr\cr
}
\details{
Setting new parameter values should only be done by advanced users.
Note that if you change any parameters, you need to re-run the analysis in order
for the parameter changes to take effect.

Tip: it can be easier to visually inspect the parameters by wrapping the
return value in a \code{str()}.

Warning: Do not directly set the GENERAL-X_VAR or GENERAL-Y_VAR parameters.
Instead, use \code{\link[ddpcr]{x_var}} or \code{\link[ddpcr]{y_var}}.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir())

# retrieving plate parameters
str(params(plate))
str(params(plate, 'GENERAL'))
params(plate, 'GENERAL', 'RANDOM_SEED')

# setting plate parameters
params(plate, 'GENERAL', 'RANDOM_SEED') <- 10
str(params(plate, 'GENERAL'))
}
}
\seealso{
\code{\link[ddpcr]{x_var}}
}

