% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difeq_replicate.R
\name{difeq_replicate}
\alias{difeq_replicate}
\title{Solve difference equations repeatedly}
\usage{
difeq_replicate(n, y, ..., as_array = TRUE)
}
\arguments{
\item{n}{Number of replicates.  It is an error to request zero
replicates.}

\item{y}{The initial state of the system.  Must be either a
numeric vector or a \code{list} of numeric vectors.  If the
latter, it must have length \code{n}.}

\item{...}{Additional arguments passed through to
\code{\link{difeq}}.}

\item{as_array}{Logical, indicating if the output should be
converted into an array.  If \code{TRUE} then \code{res[, , i]}
will contain the \code{i}'th replicate, if \code{FALSE} then
\code{res[[i]]} does instead.  If both \code{as_array} and
\code{restartable} are \code{TRUE}, then the attributes
\code{ptr} and \code{restart_data} will be present as a
\code{list} of restarting information for \code{difeq_continue},
though using these is not yet supported.}
}
\description{
Solve a replicate set of difference (or recurrence) equation by
iterating it a number of times.  This is a wrapper around
\code{\link{difeq}} that does not (yet) do anything clever to
avoid many allocations.
}
\details{
It is not currently possible to replicate over a set of parameters
at once yet; the same parameter set will be used for all
replications.

The details of how replication is done here are all considered
implementation details and are up for change in the future - in
particular if the models are run in turn or simultaneously (and
the effect that has on the random number stream).  Logic around
naming output may change in future too; note that varying names in
the \code{y} here will have some unexpected behaviours.
}
\examples{

# Here is a really simple equation that does a random walk with
# steps that are normally distributed:
rhs <- function(i, y, p) y + runif(1)
y0 <- 1
t <- 0:10
p <- 5
dde::difeq_replicate(10, y0, t, rhs, p)
}
