% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dcc_fit}
\alias{dcc_fit}
\title{DCC fit (first and second steps)}
\usage{
dcc_fit(
  r_t,
  univ_model = "sGARCH",
  distribution = "norm",
  MV = NULL,
  K = NULL,
  corr_model = "cDCC",
  lag_fun = "Beta",
  N_c = NULL,
  K_c = NULL
)
}
\arguments{
\item{r_t}{List of daily returns on which estimate a DCC model. Each daily return must be an 'xts' object.
Note that the sample period of the returns should be the same. Otherwise, a merge is performed}

\item{univ_model}{Specification of the univariate model. Valid choices are: some of the specifications used in the \code{rugarch} (\link[rugarch]{ugarchspec})
and \code{rumidas} (\link[rumidas]{ugmfit}) packages. More in detail, the models coming from \code{rugarch} are: model Valid models (currently implemented) are
'sGARCH', 'eGARCH', 'gjrGARCH', 'iGARCH', and 'csGARCH'. The models implemented from \code{rumidas} are:
'GM_skew','GM_noskew', 'DAGM_skew', and 'DAGM_noskew'}

\item{distribution}{\strong{optional} Distribution chosen for the univariate estimation. Valid choices are: "norm" (by default) and "std",
respectively, for the Normal and Student's t distributions}

\item{MV}{\strong{optional} MIDAS variable to include in the univariate estimation, if the model specificied is a GARCH-MIDAS
(GM, \insertCite{engle_ghysels_sohn_2013;textual}{dccmidas}) or a Double Asymmetric GM (DAGM, \insertCite{engle_ghysels_sohn_2013;textual}{dccmidas}).
In the case of MIDAS-based models, please provide a list of the MIDAS variables obtained from the \link[rumidas]{mv_into_mat} function.
If the same MV variable is used,  then provide always a list, with the same (transformed) variable repeated}

\item{K}{\strong{optional} The number of lagged realization of MV variable to use, if 'univ_model' has a MIDAS term}

\item{corr_model}{Correlation model used. Valid choices are: "cDCC" (the corrected DCC of \insertCite{aielli2013dynamic;textual}{dccmidas}),
"aDCC" (the asymmetric DCC model of \insertCite{cappiello2006asymmetric;textual}{dccmidas}),
"DECO" (Dynamic equicorrelation of \insertCite{engle2012dynamic;textual}{dccmidas}),
and "DCCMIDAS" (the DCC-MIDAS of \insertCite{colacito2011component;textual}{dccmidas}). By detault, it is "cDCC"}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively, if 'univ_model' has a
MIDAS term and/or if 'corr_model' is "DCCMIDAS"}

\item{N_c}{\strong{optional} Number of (lagged) realizations to use for the standarized residuals forming the long-run correlation, if 'corr_model' is "DCCMIDAS"}

\item{K_c}{\strong{optional} Number of (lagged) realizations to use for the long-run correlation, if 'corr_model' is "DCCMIDAS"}
}
\value{
\code{dcc_fit} returns an object of class 'dccmidas'. The function \code{\link{summary.dccmidas}}
can be used to print a summary of the results. Moreover, an object of class 'dccmidas' is a list containing the following components:
\itemize{
\item assets: Names of the assets considered.
\item model: Univariate model used in the first step.
\item est_univ_model: List of matrixes of estimated coefficients of the univariate model, with the QML \insertCite{Bollerslev_Wooldridge_1992}{dccmidas} standard errors.
\item corr_coef_mat: Matrix of estimated coefficients of the correlation model, with the QML standard errors.
\item mult_model: Correlation model used in the second step.
\item obs: The number of daily observations used for the estimation.
\item period: The period of the estimation.
\item H_t: Conditional covariance matrix, reported as an array.
\item R_t: Conditional correlation matrix, reported as an array.
\item R_t_bar: Conditional long-run correlation matrix, reported as an array, if the correlation matrix includes a MIDAS specification.
\item est_time: Time of estimation.
\item Days: Days of the sample period.
\item llk: The value of the log-likelihood (for the second step) at the maximum.
}
}
\description{
Obtains the estimation of a variety of DCC models, using as univariate models both GARCH and GARCH-MIDAS specifications.
}
\details{
Function \code{dcc_fit} implements the two-steps estimation of the DCC models. In the first step, a variety of univariate models are
considered. These models can be selected using for the parameter 'univ_model' one of the following choices: 'sGARCH'
(standard GARCH of \insertCite{bollerslev1986generalized;textual}{dccmidas}),
'eGARCH' of \insertCite{nelson1991conditional;textual}{dccmidas},
'gjrGARCH' of \insertCite{glosten_1993;textual}{dccmidas},
'iGARCH' (Integrated GARCH of \insertCite{engle1986modelling;textual}{dccmidas}),
'csGARCH' (the Component GARCH of \insertCite{Engle_lee_1999;textual}{dccmidas}),
'GM_noskew' and 'GM_skew' (the GARCH-MIDAS model of \insertCite{engle_ghysels_sohn_2013;textual}{dccmidas}, respectively,
without and with the asymmetric term in the short-run component),
and 'DAGM_noskew' and 'DAGM_skew' (the Double Asymmetric GARCH-MIDAS model of \insertCite{amendola_candila_gallo_2019;textual}{dccmidas},
respectively, without and with the asymmetric term in the short-run component).
}
\examples{
\donttest{
require(xts)
# open to close daily log-returns
r_t_s<-log(sp500['2005/2008'][,3])-log(sp500['2005/2008'][,1])
r_t_n<-log(nasdaq['2005/2008'][,3])-log(nasdaq['2005/2008'][,1])
r_t_f<-log(ftse100['2005/2008'][,3])-log(ftse100['2005/2008'][,1])
db_m<-merge.xts(r_t_s,r_t_n,r_t_f)
db_m<-db_m[complete.cases(db_m),]
colnames(db_m)<-c("S&P500","NASDAQ","FTSE100")
# list of returns
r_t<-list(db_m[,1],db_m[,2],db_m[,3])
# MV transformation (same MV for all the stocks)
require(rumidas)
mv_m<-mv_into_mat(r_t[[1]],diff(indpro),K=12,"monthly")
# list of MV
MV<-list(mv_m,mv_m,mv_m)
# estimation
K_c<-144
N_c<-36
dccmidas_est<-dcc_fit(r_t,univ_model="GM_noskew",distribution="norm",
MV=MV,K=12,corr_model="DCCMIDAS",N_c=N_c,K_c=K_c)
dccmidas_est
summary.dccmidas(dccmidas_est)
}
}
\references{
\insertAllCited{}
}
