% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_missing_fields.R
\name{add_missing_fields}
\alias{add_missing_fields}
\title{Add Missing Fields}
\usage{
add_missing_fields(DD.dict, DS.data)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}
}
\value{
A data frame containing the updated data dictionary with missing fields added in, or NULL if any required pre-checks fail.
}
\description{
This function adds additional fields required by this package including variable type (\code{TYPE}), minimum value (\code{MIN}), and maximum value (\code{MAX}).
}
\details{
Even though MIN, MAX, and TYPE are not required by dbGaP, our package was created to use these variables in a series of other checks and awareness functions (e.g., render_report, values_check, etc.). MIN/MAX columns will be added as empty columns as dbGaP instructions state that the MIN and MAX should be the "logical" MIN/MAX for the data, not necessarily the observed MIN/MAX, which would be study and variable specific. TYPE will be inferred from the data set and data dictionary VALUES columns. Note however, that if the VALUES columns are not set up correctly, then this function can't properly infer the data TYPE from the data set and data dictionary.
}
\examples{
# Example
data(ExampleD)
DD.dict.updated <- add_missing_fields(DD.dict.D, DS.data.D)
}
