% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_api.R
\name{reverse}
\alias{reverse}
\title{Base function for interacting with \verb{reverse geocoding} of sections.}
\usage{
reverse(section, x, y, verbose = TRUE, type = NULL, ...)
}
\arguments{
\item{section}{Defines what section of the api should be called.
\code{available_sections()} exposes all options for this parameter.}

\item{x}{The X coordinate to geocode. If no \code{srid} is provided this should be
the lattitude.}

\item{y}{The Y coordinate to geocode. If no \code{srid} is provided this should be
the longitude.}

\item{verbose}{whether or not to provide \code{{cli}} output for the user. Enabled
by default, but disabled for all functions that wrap this function}

\item{type}{The coordinate type for the API to parse. By default none is
provided and \code{WGS84} is used. The options are \code{ETRS89}, \code{UTM32} and
\code{WGS84}. The functions checks the input against the available types and
errs if the type is not allowed.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> input query parameters.}
}
\value{
Returns a list object with information about the provided \code{section}
for the location that is input.
}
\description{
This function reverse geocodes the coordinates provided. When
used out of the box, the function wants WGS84 coordinates (lat/long). ETRS89
or UTM zone 32 can be provided as well. When coordinates from outside of
Denmark is provided, the function will fail with a code \code{404}.
}
\examples{
reverse("regioner", x = 12.58515, y = 55.68324)
}
