% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone.r
\name{fill_tz}
\alias{fill_tz}
\alias{fill_utc_offsets}
\title{Fill in missing time zones and/or UTC offsets}
\usage{
fill_tz(x, tz = "")

fill_utc_offsets(x, ambiguous = "NA")
}
\arguments{
\item{x}{A datetime object}

\item{tz}{Timezone used to fill in missing time zones}

\item{ambiguous}{What to do when the "clock time" in the new time zone is ambiguous.
See \code{\link[clock:as-zoned-time-naive-time]{clock::as_zoned_time.clock_naive_time()}}.}
}
\value{
A datetime object
}
\description{
\code{fill_tz()} fills in missing time zones.
\code{fill_utc_offsets()} fills in missing UTC offsets.
}
\examples{
dts <- as_datetimeoffset(c("2020-01-01T01:01:01", "2020-01-01T01:01:01Z"))
fill_tz(dts, "UTC")
fill_tz(dts, Sys.timezone())
clock::as_sys_time(dts)
clock::as_sys_time(fill_tz(dts, "UTC"))
clock::as_zoned_time(dts)
clock::as_zoned_time(fill_tz(dts, ""))

if ("America/New_York" \%in\% OlsonNames()) {
  # non-ambiguous UTC offsets
  dt <- as_datetimeoffset("2020-11-01T12:30:00[America/New_York]")
  cat("unfilled: ", get_utc_offsets(dt), "\n")
  dt <- fill_utc_offsets(dt)
  cat("filled: ", get_utc_offsets(dt), "\n")

  # ambiguous UTC offsets due to DST
  dt0 <- as_datetimeoffset("2020-11-01T01:30:00[America/New_York]")
  dt <- fill_utc_offsets(dt0)
  cat('`ambiguous = "NA"` (default): ', get_utc_offsets(dt), "\n")
  dt <- fill_utc_offsets(dt0, ambiguous = "earliest")
  cat('`ambiguous = "earliest"`: ', get_utc_offsets(dt), "\n")
  dt <- fill_utc_offsets(dt0, ambiguous = "latest")
  cat('`ambiguos = "latest"`: ', get_utc_offsets(dt), "\n")
}
}
