% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_metadata.R
\name{put_metadata}
\alias{put_metadata}
\title{Put metadata}
\usage{
put_metadata(metadata, destination, verbose = FALSE)
}
\arguments{
\item{metadata}{a metadata list generated by generate_metadata}

\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{verbose}{TRUE /FALSE should the function be chatty?}
}
\value{
TRUE
}
\description{
Write versioned dataset metadata to a destination.
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
md <- generate_metadata(df, temp_dir)

put_metadata(md, temp_dir)
unlink(temp_dir)

}
