% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publisher.R
\name{publisher}
\alias{publisher}
\alias{publisher<-}
\title{Get/set the Publisher of the object.}
\usage{
publisher(x)

publisher(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{dataset::\link{dataset_df}} or
\code{dataset::\link{as_dataset_df}}.}

\item{overwrite}{If the attributes should be overwritten. In case it is set
to \code{FALSE},it gives a warning with the current \code{publisher}
property instead of overwriting it. Defaults to \code{FALSE}.}

\item{value}{The \code{Publisher} as a character set.}
}
\value{
The Publisher attribute as a character of length 1 is added to \code{x}.
}
\description{
Add the optional \code{Publisher} property as an attribute to an R object.
}
\details{
The \code{Publisher} corresponds to dct:publisher and Publisher in DataCite.
The name of the entity that holds, archives, publishes prints, distributes, releases,
issues, or produces the resource. This property will be used to formulate the citation,
so consider the prominence of the role. For software, use Publisher for the
code repository. If there is an entity other than a code repository, that
"holds, archives, publishes, prints, distributes, releases, issues, or produces" the
code, use the property Contributor/contributorType/ hostingInstitution for the code
repository.
}
\examples{
publisher(iris_dataset) <- "American Iris Society"
publisher(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{rights}()}
}
\concept{Reference metadata functions}
