% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head-tail.R
\name{head.dataset}
\alias{head.dataset}
\alias{tail.dataset}
\title{Return the first or last parts of a dataset object}
\usage{
\method{head}{dataset}(x, n = 6L, ...)

\method{tail}{dataset}(x, n, keepnums = FALSE, ...)
}
\arguments{
\item{x}{A dataset object created with \link{dataset}.}

\item{n}{an integer vector of length up to \code{dim(x)}
(or 1, for non-dimensioned objects). A \code{logical} is silently coerced to
integer. Values specify the indices to be selected in the corresponding
dimension (or along the length) of the object. A positive value of \code{n[i]}
includes the first/last \code{n[i]} indices in that dimension,
while a negative value excludes the last/first
\code{abs(n[i])}, including all remaining indices.
\code{NA} or non-specified values (when \code{length(n) < length(dim(x))}) select all
indices in that dimension. Must contain at least one non-missing value.}

\item{...}{Ignored.}

\item{keepnums}{in each dimension, if no names in that dimension are present,
create them using the indices included in that dimension.
Ignored if \code{dim(x)} is \code{NULL} or its length 1.}
}
\value{
A subsetted dataset, the first or last parts of a dataset object.
}
\description{
Returns the first or last parts of a dataset.
Both head() and tail() are generic functions.
}
\examples{

# Subsetting the top n rows (observations)
head(iris_dataset, n=3)

# Subsetting the last n rows (observations)
tail(iris_dataset, 3)
}
\seealso{
\link{subsetting}
}
