% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subject.R
\name{subject}
\alias{subject}
\alias{subject<-}
\alias{subject_create}
\title{Get/Add subject(s) to a dataset}
\usage{
subject(x)

subject(x, overwrite = FALSE) <- value

subject_create(
  term,
  subjectScheme = NA_character_,
  schemeURI = NA_character_,
  valueURI = NA_character_
)
}
\arguments{
\item{x}{An R object}

\item{overwrite}{Defaults to \code{FALSE}, in which case new subject(x) <- "Subject" calls
are binding further Subjects to the already set Subject properties.}

\item{value}{Subject terms, or a Subject object created by \code{\link{subject_create}}.}

\item{term}{A term, or a character vector of multiple terms.}

\item{subjectScheme}{The scheme to which the term corresponds. If there are multiple terms,
provide the subjectScheme(s) in the same order. Optional.}

\item{schemeURI}{The URI(s) of the subject identifier scheme. If there are multiple terms,
provide the schemeURIs in the same order as the terms. Optional.}

\item{valueURI}{The URI of the subject term. If there are multiple terms,
provide the valueURIs in the same order as the terms. Optional.}
}
\value{
The subjects as a data.frame of terms
}
\description{
Add one or more subject terms to the dataset's metadata.
}
\details{
In the Dublin Core elements, \href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/#https://purl.org/dc/elements/1.1/subject}{dct::subject} is
defined Typically, the subject will be represented using keywords, key phrases, or classification codes. It is
recommended as a best practice to use a controlled vocabulary. \cr
In DataCite, subjects are defined as key phrases from a controlled library.
}
\examples{
x <- data.frame( geo = c("AL", "MK"),
                value = c(1,2))
my_subject <- subject_create (
                  term = c("R (Computer program language)",
                           "Questionnaires--Computer programs"),
                  subjectScheme = rep("LC Subject Headings", 2),
                  schemeURI = rep("http://id.loc.gov/authorities/subjects",2),
                  valueURI = c("https://id.loc.gov/authorities/subjects/sh2002004407.html",
                               "http://id.worldcat.org/fast/1085693/")
)
 subject(x) <- my_subject
 subject(x)

 y <- data.frame()
 subject(y) <- "R (Computer program language)"
 subject(y) <- "Questionnaires--Computer programs"
 subject(y)
}
