% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeriesAccuracy.R
\name{DownloadSeriesAccuracy}
\alias{DownloadSeriesAccuracy}
\title{Download the series accuracy for a model, computing it if not already computed.}
\usage{
DownloadSeriesAccuracy(model, filename, encoding = "UTF-8")
}
\arguments{
\item{model}{character. The model for which you want to compute Feature Impact, e.g.
from the list of models returned by \code{ListModels(project)}.}

\item{filename}{character. Filename of file to save reason codes rows}

\item{encoding}{character. Optional. Character string A string representing the encoding
to use in the output file, defaults to 'UTF-8'.}
}
\value{
Nothing returned, but downloads the file to the stated filename.
}
\description{
Download the series accuracy for a model, computing it if not already computed.
}
\examples{
\dontrun{
  projectId <- "5984b4d7100d2b31c1166529"
  modelId <- "5984b4d7100d2b31c1166529"
  model <- GetModel(projectId, modelId)
  DownloadSeriesAccuracy(model, "seriesAccuracy.csv")
}
}
