% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Featurelists.R
\name{GetModelingFeaturelist}
\alias{GetModelingFeaturelist}
\title{Retrieve a specific modeling featurelist from a DataRobot project}
\usage{
GetModelingFeaturelist(project, featurelistId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{featurelistId}{Unique alphanumeric identifier for the featurelist
to be retrieved.}
}
\value{
A list with the following four elements describing the
requested featurelist:
\itemize{
  \item featurelistId character. The unique alphanumeric identifier for the featurelist.
  \item projectId character. The project to which the featurelist belongs.
  \item features character. The names of the variables included in the featurelist.
  \item name character. The name of the featurelist.
  \item created character. A timestamp of when the featurelist was created.
  \item isUserCreated logical. Whether or not the featurelist was created by a user
    (as opposed to DataRobot automation).
  \item numModels numeric. The number of models that currently use this featurelist.
}
}
\description{
In time series projects, a new set of modeling features is created after setting the
partitioning options. These features are automatically derived from those in the project's
dataset and are the features used for modeling. Modeling features are only accessible once
the target and partitioning options have been set. In projects that don't use time series
modeling, once the target has been set, ModelingFeaturelists and Featurelists will behave
the same.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  featureList <- CreateModelingFeaturelist(projectId, "myFeaturelist", c("feature1", "feature2"))
  featurelistId <- featureList$featurelistId
  GetModelingFeaturelist(projectId, featurelistId)
}
}
