% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/era-clim.R
\name{impossible_values}
\alias{impossible_values}
\title{Gross Errors Test for Cloud Cover and Relative Humidity.}
\usage{
impossible_values(series, meta = NULL, outpath)
}
\arguments{
\item{series}{A character string giving the path of the SEF file, or a
five or seven-column (daily or subdaily) data frame with the series.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{series} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}
}
\description{
Applicable to a series (daily or sub-daily) of relative humidity (rh) in percent
or to a series of cloud cover (n) in percent or oktas.
}
\details{
\strong{Input:}
\itemize{
\item A SEF file or a data frame and metadata. The observations data frame
must have five or seven columns: variable code, year (YYYY), month (MM), day
(DD), (hour (HH), minute (MM)), observation.
}
\strong{Output:}
\itemize{
\item A text file of flagged observations with six or eight columns: variable
code, year (YYYY), month (MM), day (DD), (hour (HH), minute (MM)),
observation, test. The test column has the description "gross_errors".
\item The flagged observations correspond to values that don't belong to the
integer interval (0, 100) if the unit is percent or that don't belong to the
integer interval (0, 9) if the unit is oktas.
}
}
\examples{
impossible_values(series = Rosario$n, meta = Meta$n, outpath = tempdir())
impossible_values(series = Rosario$rh, meta = Meta$rh, outpath = tempdir())

}
\author{
Clara Ventura, Yuri Brugnara
}
