% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_add_missing_codes.R
\name{prep_add_missing_codes}
\alias{prep_add_missing_codes}
\title{Insert missing codes for \code{NA}s based on rules}
\usage{
prep_add_missing_codes(
  resp_vars,
  study_data,
  meta_data_v2,
  item_level = "item_level",
  label_col,
  rules,
  use_value_labels,
  overwrite = FALSE,
  meta_data = item_level
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables to be
modified, all from \code{rules}, if omitted}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{rules}{\link{data.frame} with the columns:
\itemize{
\item \code{resp_vars}: Variable, whose \code{NA}-values should be replaced by jump codes
\item \code{CODE_CLASS}: Either \code{MISSING} or \code{JUMP}: Is the currently described case
an expected missing value (\code{JUMP}) or not (\code{MISSING})
\item \code{CODE_VALUE}: The jump code or missing code
\item \code{CODE_LABEL}: A label describing the reason for the missing value
\item \code{RULE}: A rule in \code{REDcap} style (see, e.g.,
\href{https://help.redcap.ualberta.ca/help-and-faq/project-best-practices/data-quality/example-data-quality-rules}{\code{REDcap} help},
\href{https://docs.google.com/document/d/1l3nGBgqqPKi5PtMe75g7q0dny8QzGMd_/edit?tab=t.0}{\code{REDcap} how-to}), and
\href{https://www.iths.org/wp-content/uploads/REDCap-Branching-Logic-2017-202.pdf}{\code{REDcap} branching logic}
that describes cases for the missing
}}

\item{use_value_labels}{\link{logical} In rules for factors, use the value labels,
not the codes. Defaults to \code{TRUE}, if any
\code{VALUE_LABELS} are given in the metadata.}

\item{overwrite}{\link{logical} Also insert missing codes, if the values are not
\code{NA}}

\item{meta_data}{\link{data.frame} old name for \code{item_level}
attributes of study data}
}
\value{
a \code{list} with the entries:
\itemize{
\item \code{ModifiedStudyData}: Study data with \code{NA}s replaced by the \code{CODE_VALUE}
\item \code{ModifiedMetaData}: Metadata having the new codes amended in the columns
\code{JUMP_LIST} or \code{MISSING_LIST}, respectively
}
}
\description{
Insert missing codes for \code{NA}s based on rules
}
