% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_remove_from_cache.R
\name{prep_remove_from_cache}
\alias{prep_remove_from_cache}
\title{Remove a specified element from the data frame cache}
\usage{
prep_remove_from_cache(object_to_remove)
}
\arguments{
\item{object_to_remove}{\link{character} name of the object to be removed
as character string (quoted), or character vector containing the names of the
objects to remove from the cache}
}
\value{
nothing
}
\description{
Remove a specified element from the data frame cache
}
\examples{
\dontrun{
prep_load_workbook_like_file("meta_data_v2") #load metadata in the cache
ls(.dataframe_environment()) #get the list of dataframes in the cache

#remove cross-item_level from the cache
prep_remove_from_cache("cross-item_level")

#remove dataframe_level and expected_id from the cache
prep_remove_from_cache(c("dataframe_level", "expected_id"))

#remove missing_table and segment_level from the cache
x<- c("missing_table", "segment_level")
prep_remove_from_cache(x)
}

}
\seealso{
Other data-frame-cache: 
\code{\link{prep_add_data_frames}()},
\code{\link{prep_get_data_frame}()},
\code{\link{prep_list_dataframes}()},
\code{\link{prep_load_folder_with_metadata}()},
\code{\link{prep_load_workbook_like_file}()},
\code{\link{prep_purge_data_frame_cache}()}
}
\concept{data-frame-cache}
