% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_compare_meta_with_study.R
\name{prep_compare_meta_with_study}
\alias{prep_compare_meta_with_study}
\title{Verify item-level metadata}
\usage{
prep_compare_meta_with_study(
  study_data,
  label_col,
  item_level = "item_level",
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
an \code{\link[=invisible]{invisible()}} list with the entries.
\itemize{
\item \code{pred} \link{data.frame} metadata predicted from \code{study_data},
reduced to such metadata also available in the provided metadata
\item \code{prov} \link{data.frame} provided metadata,
reduced to such metadata also available in the provided \code{study_data}
\item \code{ml_error} \link{character} \code{VAR_NAMES} of variables with potentially wrong
\code{MISSING_LIST}
\item \code{sl_error} \link{character} \code{VAR_NAMES} of variables with potentially wrong
\code{SCALE_LEVEL}
\item \code{dt_error} \link{character} \code{VAR_NAMES} of variables with potentially wrong
\code{DATA_TYPE}
}
}
\description{
are the provided item-level \code{meta_data} plausible given \code{study_data}?
}
