% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_univariate_outlier.R
\name{acc_robust_univariate_outlier}
\alias{acc_robust_univariate_outlier}
\title{Function to identify univariate outliers by four different approaches}
\usage{
acc_robust_univariate_outlier(
  resp_vars = NULL,
  label_col,
  study_data,
  meta_data,
  exclude_roles,
  n_rules = 4
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the continuous measurement
variable}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{exclude_roles}{\link{variable roles} a character (vector) of variable roles
not included}

\item{n_rules}{\link{integer} from=1 to=4. the no. of rules that must be violated
to flag a variable as containing outliers. The default is 4, i.e. all.}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: \code{\link{data.frame}} with the columns
\code{Variables}, \code{Mean}, \code{SD}, \code{Median}, \code{Skewness}, \code{Tukey (N)},
\code{6-Sigma (N)}, \code{Hubert (N)}, \code{Sigma-gap (N)}, \verb{Most likely (N)},
\verb{To low (N)}, \verb{To high (N)} \code{Grading}
\item \code{SummaryPlotList}: \code{\link{ggplot2}} univariate outlier plots
}
}
\description{
A classical but still popular approach to detect univariate outlier is the
boxplot method introduced by Tukey 1977. The boxplot is a simple graphical
tool to display information about continuous univariate data (e.g., median,
lower and upper quartile). Outliers are defined as values deviating more
than \eqn{1.5 \times IQR} from the 1st (Q25) or 3rd (Q75) quartile. The
strength of Tukey’s method is that it makes no distributional assumptions
and thus is also applicable to skewed or non mound-shaped data
Marsh and Seo, 2006. Nevertheless, this method tends to identify frequent
measurements which are falsely interpreted as true outliers.

A somewhat more conservative approach in terms of symmetric and/or normal
distributions is the \eqn{6 * \sigma} approach, i.e. any measurement not in
the interval of \eqn{mean(x) +/- 3 * \sigma} is considered an outlier.

Both methods mentioned above are not ideally suited to skewed distributions.
As many biomarkers such as laboratory measurements represent in skewed
distributions the methods above may be insufficient. The approach of Hubert
and Vandervieren 2008 adjusts the boxplot for the skewness of the
distribution. This approach is implemented in several R packages such as
\code{\link[robustbase:mc]{robustbase::mc}} which is used in this implementation of \code{\link{dataquieR}}.

Another completely heuristic approach is also included to identify outliers.
The approach is based on the assumption that the distances between
measurements of the same underlying distribution should homogeneous. For
comprehension of this approach:
\itemize{
\item consider an ordered sequence of all measurements.
\item between these measurements all distances are calculated.
\item the occurrence of larger distances between two neighboring measurements
may
than indicate a distortion of the data. For the heuristic definition of a
large distance \eqn{1 * \sigma} has been been chosen.
}
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item Select all variables of type float in the study data
\item Remove missing codes from the study data (if defined in the metadata)
\item Remove measurements deviating from limits defined in the metadata
\item Identify outlier according to the approaches of Tukey (Tukey 1977),
SixSigma (-Bakar et al. 2006), Hubert (Hubert and Vandervieren 2008),
and SigmaGap (heuristic)
\item A output data frame is generated which indicates the no. of possible
outlier, the direction of deviations (to low, to high) for all methods
and a summary score which sums up the deviations of the different rules
\item A scatter plot is generated for all examined variables, flagging
observations according to the no. of violated rules (step 5).
}
}

\seealso{
\link{acc_univariate_outlier}
}
