/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RootInputStream
extends FilterInputStream {
    private int lineNumber = 1;
    private int prev = -1;
    private boolean truncated = false;

    public RootInputStream(InputStream is) {
        super(is);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void truncate() {
        this.truncated = true;
    }

    public int read() throws IOException {
        if (this.truncated) {
            return -1;
        }
        int b = this.in.read();
        if (this.prev == 13 && b == 10) {
            ++this.lineNumber;
        }
        this.prev = b;
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.truncated) {
            return -1;
        }
        int n = this.in.read(b, off, len);
        for (int i = off; i < off + n; ++i) {
            if (this.prev == 13 && b[i] == 10) {
                ++this.lineNumber;
            }
            this.prev = b[i];
        }
        return n;
    }
}

