/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CloseShieldInputStream
extends FilterInputStream {
    public CloseShieldInputStream(InputStream is) {
        super(is);
    }

    public InputStream getUnderlyingStream() {
        return this.in;
    }

    public int read() throws IOException {
        this.checkIfClosed();
        return this.in.read();
    }

    public int available() throws IOException {
        this.checkIfClosed();
        return this.in.available();
    }

    public void close() throws IOException {
        this.in = null;
    }

    public synchronized void reset() throws IOException {
        this.checkIfClosed();
        this.in.reset();
    }

    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    public synchronized void mark(int readlimit) {
        if (this.in != null) {
            this.in.mark(readlimit);
        }
    }

    public long skip(long n) throws IOException {
        this.checkIfClosed();
        return this.in.skip(n);
    }

    public int read(byte[] b) throws IOException {
        this.checkIfClosed();
        return this.in.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkIfClosed();
        return this.in.read(b, off, len);
    }

    private void checkIfClosed() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream is closed");
        }
    }
}

