/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.james.mime4j.decoder.DecoderUtil;
import org.apache.james.mime4j.field.address.Address;
import org.apache.james.mime4j.field.address.AddressList;
import org.apache.james.mime4j.field.address.DomainList;
import org.apache.james.mime4j.field.address.Group;
import org.apache.james.mime4j.field.address.Mailbox;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.field.address.NamedMailbox;
import org.apache.james.mime4j.field.address.parser.ASTaddr_spec;
import org.apache.james.mime4j.field.address.parser.ASTaddress;
import org.apache.james.mime4j.field.address.parser.ASTaddress_list;
import org.apache.james.mime4j.field.address.parser.ASTangle_addr;
import org.apache.james.mime4j.field.address.parser.ASTdomain;
import org.apache.james.mime4j.field.address.parser.ASTgroup_body;
import org.apache.james.mime4j.field.address.parser.ASTlocal_part;
import org.apache.james.mime4j.field.address.parser.ASTmailbox;
import org.apache.james.mime4j.field.address.parser.ASTname_addr;
import org.apache.james.mime4j.field.address.parser.ASTphrase;
import org.apache.james.mime4j.field.address.parser.ASTroute;
import org.apache.james.mime4j.field.address.parser.Node;
import org.apache.james.mime4j.field.address.parser.SimpleNode;
import org.apache.james.mime4j.field.address.parser.Token;

class Builder {
    private static Builder singleton = new Builder();

    Builder() {
    }

    public static Builder getInstance() {
        return singleton;
    }

    public AddressList buildAddressList(ASTaddress_list node) {
        ArrayList<Address> list = new ArrayList<Address>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTaddress childNode = (ASTaddress)node.jjtGetChild(i);
            Address address = this.buildAddress(childNode);
            list.add(address);
        }
        return new AddressList(list, true);
    }

    private Address buildAddress(ASTaddress node) {
        ChildNodeIterator it = new ChildNodeIterator(node);
        Node n = it.nextNode();
        if (n instanceof ASTaddr_spec) {
            return this.buildAddrSpec((ASTaddr_spec)n);
        }
        if (n instanceof ASTangle_addr) {
            return this.buildAngleAddr((ASTangle_addr)n);
        }
        if (n instanceof ASTphrase) {
            String name = this.buildString((ASTphrase)n, false);
            Node n2 = it.nextNode();
            if (n2 instanceof ASTgroup_body) {
                return new Group(name, this.buildGroupBody((ASTgroup_body)n2));
            }
            if (n2 instanceof ASTangle_addr) {
                name = DecoderUtil.decodeEncodedWords(name);
                return new NamedMailbox(name, this.buildAngleAddr((ASTangle_addr)n2));
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    private MailboxList buildGroupBody(ASTgroup_body node) {
        ArrayList<Mailbox> results = new ArrayList<Mailbox>();
        ChildNodeIterator it = new ChildNodeIterator(node);
        while (it.hasNext()) {
            Node n = it.nextNode();
            if (n instanceof ASTmailbox) {
                results.add(this.buildMailbox((ASTmailbox)n));
                continue;
            }
            throw new IllegalStateException();
        }
        return new MailboxList(results, true);
    }

    private Mailbox buildMailbox(ASTmailbox node) {
        ChildNodeIterator it = new ChildNodeIterator(node);
        Node n = it.nextNode();
        if (n instanceof ASTaddr_spec) {
            return this.buildAddrSpec((ASTaddr_spec)n);
        }
        if (n instanceof ASTangle_addr) {
            return this.buildAngleAddr((ASTangle_addr)n);
        }
        if (n instanceof ASTname_addr) {
            return this.buildNameAddr((ASTname_addr)n);
        }
        throw new IllegalStateException();
    }

    private NamedMailbox buildNameAddr(ASTname_addr node) {
        ChildNodeIterator it = new ChildNodeIterator(node);
        Node n = it.nextNode();
        if (!(n instanceof ASTphrase)) {
            throw new IllegalStateException();
        }
        String name = this.buildString((ASTphrase)n, false);
        n = it.nextNode();
        if (n instanceof ASTangle_addr) {
            name = DecoderUtil.decodeEncodedWords(name);
            return new NamedMailbox(name, this.buildAngleAddr((ASTangle_addr)n));
        }
        throw new IllegalStateException();
    }

    private Mailbox buildAngleAddr(ASTangle_addr node) {
        ChildNodeIterator it = new ChildNodeIterator(node);
        DomainList route = null;
        Node n = it.nextNode();
        if (n instanceof ASTroute) {
            route = this.buildRoute((ASTroute)n);
            n = it.nextNode();
        } else if (!(n instanceof ASTaddr_spec)) {
            throw new IllegalStateException();
        }
        if (n instanceof ASTaddr_spec) {
            return this.buildAddrSpec(route, (ASTaddr_spec)n);
        }
        throw new IllegalStateException();
    }

    private DomainList buildRoute(ASTroute node) {
        ArrayList<String> results = new ArrayList<String>(node.jjtGetNumChildren());
        ChildNodeIterator it = new ChildNodeIterator(node);
        while (it.hasNext()) {
            Node n = it.nextNode();
            if (n instanceof ASTdomain) {
                results.add(this.buildString((ASTdomain)n, true));
                continue;
            }
            throw new IllegalStateException();
        }
        return new DomainList(results, true);
    }

    private Mailbox buildAddrSpec(ASTaddr_spec node) {
        return this.buildAddrSpec(null, node);
    }

    private Mailbox buildAddrSpec(DomainList route, ASTaddr_spec node) {
        ChildNodeIterator it = new ChildNodeIterator(node);
        String localPart = this.buildString((ASTlocal_part)it.nextNode(), true);
        String domain = this.buildString((ASTdomain)it.nextNode(), true);
        return new Mailbox(route, localPart, domain);
    }

    private String buildString(SimpleNode node, boolean stripSpaces) {
        Token head = node.firstToken;
        Token tail = node.lastToken;
        StringBuffer out = new StringBuffer();
        while (head != tail) {
            out.append(head.image);
            head = head.next;
            if (stripSpaces) continue;
            this.addSpecials(out, head.specialToken);
        }
        out.append(tail.image);
        return out.toString();
    }

    private void addSpecials(StringBuffer out, Token specialToken) {
        if (specialToken != null) {
            this.addSpecials(out, specialToken.specialToken);
            out.append(specialToken.image);
        }
    }

    private static class ChildNodeIterator
    implements Iterator {
        private SimpleNode simpleNode;
        private int index;
        private int len;

        public ChildNodeIterator(SimpleNode simpleNode) {
            this.simpleNode = simpleNode;
            this.len = simpleNode.jjtGetNumChildren();
            this.index = 0;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.len;
        }

        public Object next() {
            return this.nextNode();
        }

        public Node nextNode() {
            return this.simpleNode.jjtGetChild(this.index++);
        }
    }
}

