/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v1.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.dataone.service.types.v1.Checksum;

public class ChecksumUtil {
    public static Checksum checksum(InputStream is, String checksumAlgorithm) throws NoSuchAlgorithmException, IOException {
        int numRead;
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance(checksumAlgorithm);
        do {
            if ((numRead = is.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        if (is.markSupported()) {
            is.reset();
        }
        String csStr = ChecksumUtil.getHex(complete.digest());
        Checksum checksum = new Checksum();
        checksum.setValue(csStr);
        checksum.setAlgorithm(checksumAlgorithm);
        return checksum;
    }

    public static Checksum checksum(byte[] object, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest complete = MessageDigest.getInstance(algorithm);
        complete.update(object);
        String csStr = ChecksumUtil.getHex(complete.digest());
        Checksum checksum = new Checksum();
        checksum.setValue(csStr);
        checksum.setAlgorithm(algorithm);
        return checksum;
    }

    private static String getHex(byte[] raw) {
        String HEXES = "0123456789abcdef";
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append("0123456789abcdef".charAt((b & 0xF0) >> 4)).append("0123456789abcdef".charAt(b & 0xF));
        }
        return hex.toString();
    }
}

