/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.ClientProtocolException;
import org.dataone.client.D1Node;
import org.dataone.client.D1RestClient;
import org.dataone.client.ObjectFormatCache;
import org.dataone.configuration.Settings;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.cn.v1.CNAuthorization;
import org.dataone.service.cn.v1.CNCore;
import org.dataone.service.cn.v1.CNIdentity;
import org.dataone.service.cn.v1.CNRead;
import org.dataone.service.cn.v1.CNRegister;
import org.dataone.service.cn.v1.CNReplication;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidCredentials;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.ChecksumAlgorithmList;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeList;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormat;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectFormatList;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1.util.NodelistUtil;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.util.D1Url;
import org.jibx.runtime.JiBXException;

public class CNode
extends D1Node
implements CNCore,
CNRead,
CNAuthorization,
CNIdentity,
CNRegister,
CNReplication {
    protected static Log log = LogFactory.getLog(CNode.class);
    private Map<String, String> nodeId2URLMap;
    private long lastNodeListRefreshTimeMS = 0L;
    private Integer nodelistRefreshIntervalSeconds = Settings.getConfiguration().getInteger("CNode.nodemap.cache.refresh.interval.seconds", this.nodelistRefreshIntervalSeconds);
    private static final String REPLICATION_TIMEOUT_PROPERTY = "D1Client.CNode.replication.timeout";

    public CNode(String nodeBaseServiceUrl) {
        super(nodeBaseServiceUrl);
    }

    public CNode(String nodeBaseServiceUrl, Session session) {
        super(nodeBaseServiceUrl, session);
    }

    @Override
    public String getNodeBaseServiceUrl() {
        D1Url url = new D1Url(super.getNodeBaseServiceUrl());
        url.addNextPathElement("v1");
        return url.getUrl();
    }

    public String lookupNodeBaseUrl(String nodeId) throws ServiceFailure, NotImplemented {
        if (nodeId == null) {
            nodeId = "";
        }
        String url = null;
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
            url = this.nodeId2URLMap.get(nodeId);
        } else {
            url = this.nodeId2URLMap.get(nodeId);
            if (url == null) {
                this.refreshNodeMap();
                url = this.nodeId2URLMap.get(nodeId);
            }
        }
        return url;
    }

    public String lookupNodeBaseUrl(NodeReference nodeRef) throws ServiceFailure, NotImplemented {
        String nodeId;
        String string = nodeId = nodeRef == null ? "" : nodeRef.getValue();
        if (nodeId == null) {
            nodeId = "";
        }
        String url = null;
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
            url = this.nodeId2URLMap.get(nodeId);
        } else {
            url = this.nodeId2URLMap.get(nodeId);
            if (url == null) {
                this.refreshNodeMap();
                url = this.nodeId2URLMap.get(nodeId);
            }
        }
        return url;
    }

    public String lookupNodeId(String nodeBaseUrl) throws ServiceFailure, NotImplemented {
        String nodeId = "";
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
        }
        for (String key : this.nodeId2URLMap.keySet()) {
            if (!nodeBaseUrl.equals(this.nodeId2URLMap.get(key))) continue;
            nodeId = key;
            break;
        }
        return nodeId;
    }

    private void refreshNodeMap() throws ServiceFailure, NotImplemented {
        this.nodeId2URLMap = NodelistUtil.mapNodeList((NodeList)this.listNodes());
    }

    public Set<String> listNodeIds() throws ServiceFailure, NotImplemented {
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
        }
        return this.nodeId2URLMap.keySet();
    }

    private boolean isNodeMapStale() {
        if (this.nodeId2URLMap == null) {
            return true;
        }
        Date now = new Date();
        long nowMS = now.getTime();
        DateFormat df = DateFormat.getDateTimeInstance();
        df.format(now);
        long refreshIntervalMS = (long)this.nodelistRefreshIntervalSeconds.intValue() * 1000L;
        if (nowMS - this.lastNodeListRefreshTimeMS > refreshIntervalMS) {
            this.lastNodeListRefreshTimeMS = nowMS;
            log.info((Object)("  CNode nodelist refresh: new cached time: " + df.format(now)));
            return true;
        }
        return false;
    }

    @Override
    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        return super.ping();
    }

    public ObjectFormatList listFormats() throws ServiceFailure, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "formats");
        D1RestClient client = new D1RestClient();
        ObjectFormatList formatList = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            formatList = this.deserializeServiceType(ObjectFormatList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return formatList;
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier formatid) throws ServiceFailure, NotFound, NotImplemented {
        ObjectFormat objectFormat = null;
        boolean useObjectFormatCache = false;
        useObjectFormatCache = Settings.getConfiguration().getBoolean("CNode.useObjectFormatCache", useObjectFormatCache);
        if (useObjectFormatCache) {
            try {
                objectFormat = ObjectFormatCache.getInstance().getFormat(formatid);
            }
            catch (BaseException be) {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                throw CNode.recastDataONEExceptionToServiceFailure(be);
            }
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "formats");
        url.addNextPathElement(formatid.getValue());
        D1RestClient client = new D1RestClient();
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            objectFormat = this.deserializeServiceType(ObjectFormat.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return objectFormat;
    }

    public ChecksumAlgorithmList listChecksumAlgorithms() throws ServiceFailure, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "checksum");
        D1RestClient client = new D1RestClient();
        ChecksumAlgorithmList algorithmList = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            algorithmList = this.deserializeServiceType(ChecksumAlgorithmList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return algorithmList;
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords() throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return super.getLogRecords();
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords(Session session) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return super.getLogRecords(session);
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords(Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return super.getLogRecords(fromDate, toDate, event, pidFilter, start, count);
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords(Session session, Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return super.getLogRecords(session, fromDate, toDate, event, pidFilter, start, count);
    }

    public NodeList listNodes() throws NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        D1RestClient client = new D1RestClient();
        NodeList nodelist = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            nodelist = this.deserializeServiceType(NodeList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return nodelist;
    }

    public Identifier reserveIdentifier(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        return this.reserveIdentifier(this.session, pid);
    }

    public Identifier reserveIdentifier(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "reserve");
        SimpleMultipartEntity smpe = new SimpleMultipartEntity();
        if (pid == null) {
            throw new InvalidRequest("0000", "PID cannot be null");
        }
        smpe.addParamPart("pid", pid.getValue());
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.CNode.reserveIdentifier.timeout", this.getDefaultSoTimeout()));
        Identifier identifier = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), smpe);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    @Override
    public Identifier generateIdentifier(String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return super.generateIdentifier(scheme, fragment);
    }

    @Override
    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return super.generateIdentifier(session, scheme, fragment);
    }

    public boolean hasReservation(Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, IdentifierNotUnique {
        return this.hasReservation(this.session, subject, pid);
    }

    public boolean hasReservation(Session session, Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "reserve");
        try {
            if (subject != null) {
                url.addNonEmptyParamPair("subject", subject.getValue());
            }
            if (pid != null) {
                url.addNextPathElement(pid.getValue());
            }
        }
        catch (Exception e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public Identifier create(Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        return this.create(this.session, pid, object, sysmeta);
    }

    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        if (pid == null) {
            throw new InvalidRequest("0000", "PID cannot be null");
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            if (object == null) {
                mpe.addFilePart("object", "");
            } else {
                mpe.addFilePart("object", object);
            }
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (JiBXException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.CNode.create.timeout", this.getDefaultSoTimeout()));
        Identifier identifier = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    public Identifier registerSystemMetadata(Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        return this.registerSystemMetadata(this.session, pid, sysmeta);
    }

    public Identifier registerSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "meta");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.CNode.registerSystemMetadata.timeout", this.getDefaultSoTimeout()));
        Identifier identifier = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    public boolean setObsoletedBy(Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        return this.setObsoletedBy(this.session, pid, obsoletedByPid, serialVersion);
    }

    public boolean setObsoletedBy(Session session, Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "obsoletedBy");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (obsoletedByPid != null) {
            mpe.addParamPart("obsoletedByPid", obsoletedByPid.getValue());
        }
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    @Override
    public ObjectList listObjects() throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects();
    }

    @Override
    public ObjectList listObjects(Session session) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects(session);
    }

    @Override
    public ObjectList listObjects(Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects(fromDate, toDate, formatid, replicaStatus, start, count);
    }

    @Override
    public ObjectList listObjects(Session session, Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects(session, fromDate, toDate, formatid, replicaStatus, start, count);
    }

    @Override
    public InputStream get(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        try {
            return super.get(pid);
        }
        catch (InsufficientResources e) {
            throw CNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
    }

    @Override
    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        try {
            return super.get(session, pid);
        }
        catch (InsufficientResources e) {
            throw CNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
    }

    @Override
    public SystemMetadata getSystemMetadata(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.getSystemMetadata(pid);
    }

    @Override
    public SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.getSystemMetadata(session, pid);
    }

    @Override
    public DescribeResponse describe(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.describe(pid);
    }

    @Override
    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.describe(session, pid);
    }

    public ObjectLocationList resolve(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.resolve(this.session, pid);
    }

    public ObjectLocationList resolve(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "resolve");
        if (pid == null) {
            throw new NotFound("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        D1RestClient client = new D1RestClient(session);
        client.getHttpClient().getParams().setParameter("http.protocol.handle-redirects", (Object)false);
        ObjectLocationList oll = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl(), true);
            oll = this.deserializeServiceType(ObjectLocationList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return oll;
    }

    public Checksum getChecksum(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Checksum cs = null;
        try {
            cs = super.getChecksum(pid, null);
        }
        catch (InvalidRequest e) {
            throw CNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return cs;
    }

    public Checksum getChecksum(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Checksum cs = null;
        try {
            cs = super.getChecksum(session, pid, null);
        }
        catch (InvalidRequest e) {
            throw CNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return cs;
    }

    public ObjectList search(String queryType, D1Url queryD1url) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.search(this.session, queryType, queryD1url);
    }

    public ObjectList search(Session session, String queryType, D1Url queryD1url) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        String pathAndQueryString = queryD1url.getUrl();
        return this.search(session, queryType, pathAndQueryString);
    }

    public ObjectList search(String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.search(this.session, queryType, query);
    }

    public ObjectList search(Session session, String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "search");
        url.addNextPathElement(queryType);
        String finalUrl = url.getUrl() + "/" + query;
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.CNode.search.timeout", this.getDefaultSoTimeout()));
        ObjectList objectList = null;
        try {
            InputStream is = client.doGetRequest(finalUrl);
            objectList = this.deserializeServiceType(ObjectList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return objectList;
    }

    public Identifier setRightsHolder(Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        return this.setRightsHolder(this.session, pid, userId, serialVersion);
    }

    public Identifier setRightsHolder(Session session, Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "owner");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (userId == null) {
            throw new InvalidRequest("0000", "parameter 'userId' cannot be null");
        }
        mpe.addParamPart("userId", userId.getValue());
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        D1RestClient client = new D1RestClient(session);
        Identifier identifier = null;
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    @Override
    public boolean isAuthorized(Identifier pid, Permission permission) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        return super.isAuthorized(pid, permission);
    }

    @Override
    public boolean isAuthorized(Session session, Identifier pid, Permission permission) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        return super.isAuthorized(session, pid, permission);
    }

    public boolean setAccessPolicy(Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, VersionMismatch {
        return this.setAccessPolicy(this.session, pid, accessPolicy, serialVersion);
    }

    public boolean setAccessPolicy(Session session, Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accessRules");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("accessPolicy", (Object)accessPolicy);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public Subject registerAccount(Person person) throws ServiceFailure, NotAuthorized, IdentifierNotUnique, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken {
        return this.registerAccount(this.session, person);
    }

    public Subject registerAccount(Session session, Person person) throws ServiceFailure, NotAuthorized, IdentifierNotUnique, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("person", (Object)person);
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        Subject subject = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InvalidCredentials) {
                throw (InvalidCredentials)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return subject;
    }

    public Subject updateAccount(Person person) throws ServiceFailure, NotAuthorized, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken, NotFound {
        return this.updateAccount(this.session, person);
    }

    public Subject updateAccount(Session session, Person person) throws ServiceFailure, NotAuthorized, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken, NotFound {
        if (person.getSubject() == null) {
            throw new NotFound("0000", "'person.subject' cannot be null");
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        url.addNextPathElement(person.getSubject().getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("person", (Object)person);
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        Subject subject = null;
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof InvalidCredentials) {
                throw (InvalidCredentials)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return subject;
    }

    public boolean verifyAccount(Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, InvalidToken, InvalidRequest {
        return this.verifyAccount(this.session, subject);
    }

    public boolean verifyAccount(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, InvalidToken, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/verification");
        if (subject == null) {
            throw new InvalidRequest("0000", "'subject' cannot be null");
        }
        url.addNextPathElement(subject.getValue());
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPutRequest(url.getUrl(), null);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public SubjectInfo getSubjectInfo(Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound, InvalidToken {
        return this.getSubjectInfo(this.session, subject);
    }

    public SubjectInfo getSubjectInfo(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        if (subject == null) {
            throw new NotFound("0000", "'subject' cannot be null");
        }
        url.addNextPathElement(subject.getValue());
        D1RestClient client = new D1RestClient(session);
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return subjectInfo;
    }

    public SubjectInfo listSubjects(String query, String status, Integer start, Integer count) throws InvalidRequest, ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        return this.listSubjects(this.session, query, status, start, count);
    }

    public SubjectInfo listSubjects(Session session, String query, String status, Integer start, Integer count) throws InvalidRequest, ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        url.addNonEmptyParamPair("query", query);
        url.addNonEmptyParamPair("status", status);
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        D1RestClient client = new D1RestClient(session);
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return subjectInfo;
    }

    public boolean mapIdentity(Subject primarySubject, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        return this.mapIdentity(this.session, primarySubject, secondarySubject);
    }

    public boolean mapIdentity(Session session, Subject primarySubject, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/map");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (primarySubject != null) {
            mpe.addParamPart("primarySubject", primarySubject.getValue());
        }
        if (secondarySubject != null) {
            mpe.addParamPart("secondarySubject", secondarySubject.getValue());
        }
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean requestMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        return this.requestMapIdentity(this.session, subject);
    }

    public boolean requestMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("subject", subject.getValue());
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public SubjectInfo getPendingMapIdentity(Subject subject) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.getPendingMapIdentity(this.session, subject);
    }

    public SubjectInfo getPendingMapIdentity(Session session, Subject subject) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        D1RestClient client = new D1RestClient(session);
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return subjectInfo;
    }

    public boolean confirmMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        return this.confirmMapIdentity(this.session, subject);
    }

    public boolean confirmMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPutRequest(url.getUrl(), null);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean denyMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        return this.denyMapIdentity(this.session, subject);
    }

    public boolean denyMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doDeleteRequest(url.getUrl());
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean removeMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        return this.removeMapIdentity(this.session, subject);
    }

    public boolean removeMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/map");
        url.addNextPathElement(subject.getValue());
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doDeleteRequest(url.getUrl());
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public Subject createGroup(Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented, IdentifierNotUnique {
        return this.createGroup(this.session, group);
    }

    public Subject createGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "groups");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("group", (Object)group);
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        Subject subject = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return subject;
    }

    public boolean updateGroup(Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        return this.updateGroup(this.session, group);
    }

    public boolean updateGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "groups");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("group", (Object)group);
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean updateNodeCapabilities(NodeReference nodeid, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, NotFound, InvalidToken {
        return this.updateNodeCapabilities(this.session, nodeid, node);
    }

    public boolean updateNodeCapabilities(Session session, NodeReference nodeid, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, NotFound, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        if (nodeid != null) {
            url.addNextPathElement(nodeid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("node", (Object)node);
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public NodeReference register(Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, IdentifierNotUnique, InvalidToken {
        return this.register(this.session, node);
    }

    public NodeReference register(Session session, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, IdentifierNotUnique, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("node", (Object)node);
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        NodeReference nodeRef = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            nodeRef = this.deserializeServiceType(NodeReference.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return nodeRef;
    }

    public boolean setReplicationStatus(Identifier pid, NodeReference nodeRef, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        return this.setReplicationStatus(this.session, pid, nodeRef, status, failure);
    }

    public boolean setReplicationStatus(Session session, Identifier pid, NodeReference nodeRef, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaNotifications");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("nodeRef", nodeRef.getValue());
        mpe.addParamPart("status", status.xmlValue());
        try {
            if (failure != null) {
                mpe.addFilePart("failure", failure.serialize(0));
            }
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger(REPLICATION_TIMEOUT_PROPERTY, this.getDefaultSoTimeout()));
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean setReplicationPolicy(Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        return this.setReplicationPolicy(this.session, pid, policy, serialVersion);
    }

    public boolean setReplicationPolicy(Session session, Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaPolicies");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("policy", (Object)policy);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger(REPLICATION_TIMEOUT_PROPERTY, this.getDefaultSoTimeout()));
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean isNodeAuthorized(Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        return this.isNodeAuthorized(this.session, targetNodeSubject, pid);
    }

    public boolean isNodeAuthorized(Session session, Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaAuthorizations");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        if (targetNodeSubject != null) {
            url.addNonEmptyParamPair("targetNodeSubject", targetNodeSubject.getValue());
        }
        D1RestClient client = new D1RestClient(session);
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean updateReplicationMetadata(Identifier pid, Replica replicaMetadata, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, NotFound, InvalidRequest, InvalidToken, VersionMismatch {
        return this.updateReplicationMetadata(this.session, pid, replicaMetadata, serialVersion);
    }

    public boolean updateReplicationMetadata(Session session, Identifier pid, Replica replicaMetadata, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, NotFound, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaMetadata");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("replicaMetadata", (Object)replicaMetadata);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger(REPLICATION_TIMEOUT_PROPERTY, this.getDefaultSoTimeout()));
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean deleteReplicationMetadata(Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch, InvalidRequest {
        return this.deleteReplicationMetadata(this.session, pid, nodeId, serialVersion);
    }

    public boolean deleteReplicationMetadata(Session session, Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "removeReplicaMetadata");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (nodeId != null) {
            mpe.addParamPart("nodeId", nodeId.getValue());
        }
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger(REPLICATION_TIMEOUT_PROPERTY, this.getDefaultSoTimeout()));
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw CNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw CNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw CNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    @Override
    public Identifier archive(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.archive(pid);
    }

    @Override
    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.archive(session, pid);
    }

    @Override
    public Identifier delete(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.delete(pid);
    }

    @Override
    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.delete(session, pid);
    }

    @Override
    public InputStream query(String queryEngine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return super.query(queryEngine, query);
    }

    @Override
    public InputStream query(String queryEngine, D1Url queryD1Url) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return super.query(queryEngine, queryD1Url.getUrl());
    }

    @Override
    public QueryEngineDescription getQueryEngineDescription(String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        return super.getQueryEngineDescription(queryEngine);
    }

    @Override
    public QueryEngineList listQueryEngines() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        return super.listQueryEngines();
    }
}

