/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.describe;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.describe.DescribeBNodeClosureFactory;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandler;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandlerFactory;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DescribeHandlerRegistry {
    private static DescribeHandlerRegistry globalRegistry = null;
    private List registry = new ArrayList();

    private DescribeHandlerRegistry() {
    }

    private static synchronized DescribeHandlerRegistry standardRegistry() {
        DescribeHandlerRegistry reg = new DescribeHandlerRegistry();
        reg.add(new DescribeBNodeClosureFactory());
        return reg;
    }

    public static DescribeHandlerRegistry get(Context context) {
        if (context == null) {
            return null;
        }
        return (DescribeHandlerRegistry)ARQ.getContext().get(ARQConstants.registryDescribeHandlers);
    }

    public static void set(Context context, DescribeHandlerRegistry reg) {
        context.set(ARQConstants.registryDescribeHandlers, reg);
    }

    public static DescribeHandlerRegistry get() {
        DescribeHandlerRegistry reg = DescribeHandlerRegistry.get(ARQ.getContext());
        if (reg == null) {
            reg = DescribeHandlerRegistry.standardRegistry();
            DescribeHandlerRegistry.set(ARQ.getContext(), reg);
        }
        return reg;
    }

    public void add(DescribeHandlerFactory handlerFactory) {
        this.registry.add(0, handlerFactory);
    }

    public void remove(DescribeHandlerFactory handlerFactory) {
        this.registry.remove(handlerFactory);
    }

    public void clear() {
        this.registry.clear();
    }

    public List newHandlerList() {
        ArrayList<DescribeHandler> a = new ArrayList<DescribeHandler>();
        Iterator iter = this.handlers();
        while (iter.hasNext()) {
            DescribeHandlerFactory f = (DescribeHandlerFactory)iter.next();
            a.add(f.create());
        }
        return a;
    }

    public Iterator handlers() {
        return this.registry.iterator();
    }
}

