% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descstat.R
\name{descstat}
\alias{descstat}
\title{A function that prepares a descriptive statistics table for continuous variables.}
\usage{
descstat(data = data, decnum = NA)
}
\arguments{
\item{data}{a dataframe containing variables as columns.}

\item{decnum}{the number of decimals to be used in the output.}
}
\value{
This function wraps descriptive statistics into a summarize table having the following
  descriptive statistics: sample size, minimum, maximum, mean, median, SD, and coefficient of variation (%).
}
\description{
Function that creates a descriptive statistics table for all continuous variables in a dataframe excluding missing values.
}
\examples{

#creating a fake dataframe
set.seed(1234)
df <- as.data.frame(cbind(variable1=rnorm(5, 0), variable2=rnorm(5, 2)))
## adding one missing value
df[3,1] <- NA
df
#using the function
descstat(data=df)
descstat(data=df,decnum=1)
descstat(df,2)
}
\author{
Christian Salas-Eljatib and Tomas Cayul.
}
