% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_data.R
\name{show_data}
\alias{show_data}
\title{Display a table in a window}
\usage{
show_data(
  data,
  title = NULL,
  options = NULL,
  show_classes = TRUE,
  type = c("popup", "modal", "winbox"),
  width = "65\%",
  ...
)
}
\arguments{
\item{data}{a data object (either a \code{matrix} or a \code{data.frame}).}

\item{title}{Title to be displayed in window.}

\item{options}{Arguments passed to \code{\link[toastui:datagrid]{toastui::datagrid()}}.}

\item{show_classes}{Show variables classes under variables names in table header.}

\item{type}{Display table in a pop-up with \code{\link[shinyWidgets:sweetalert]{shinyWidgets::show_alert()}},
in modal window with \code{\link[shiny:showModal]{shiny::showModal()}} or in a WinBox window with \code{\link[shinyWidgets:WinBox]{shinyWidgets::WinBox()}}.}

\item{width}{Width of the window, only used if \code{type = "popup"} or \code{type = "winbox"}.}

\item{...}{Additional options, such as \code{wbOptions = wbOptions()} or \code{wbControls = wbControls()}.}
}
\value{
No value.
}
\description{
Display a table in a window
}
\note{
If you use \code{type = "winbox"}, you'll need to use \code{shinyWidgets::html_dependency_winbox()} somewhere in your UI.
}
\examples{

library(shiny)
library(datamods)

ui <- fluidPage(
  theme = bslib::bs_theme(version = 5L),
  shinyWidgets::html_dependency_winbox(),
  actionButton(
    inputId = "show1",
    label = "Show data in popup",
    icon = icon("eye")
  ),
  actionButton(
    inputId = "show2",
    label = "Show data in modal",
    icon = icon("eye")
  ),
  actionButton(
    inputId = "show3",
    label = "Show data without classes",
    icon = icon("eye")
  ),
  actionButton(
    inputId = "show4",
    label = "Show data in Winbox",
    icon = icon("eye")
  )
)

server <- function(input, output, session) {
  observeEvent(input$show1, {
    show_data(MASS::Cars93, title = "MASS::Cars93 dataset", type = "popup")
  })
  observeEvent(input$show2, {
    show_data(MASS::Cars93, title = "MASS::Cars93 dataset", type = "modal")
  })
  observeEvent(input$show3, {
    show_data(
      data = MASS::Cars93,
      title = "MASS::Cars93 dataset",
      show_classes = FALSE,
      options = list(pagination = 10),
      type = "modal"
    )
  })
  observeEvent(input$show4, {
    show_data(
      MASS::Cars93,
      title = "MASS::Cars93 dataset",
      type = "winbox",
      wbOptions = shinyWidgets::wbOptions(background = "forestgreen")
    )
  })
}

if (interactive())
  shinyApp(ui, server)
}
