% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_arcs}
\alias{add_arcs}
\title{Add arcs}
\usage{
add_arcs(p, origin.lon, origin.lat, destination.lon, destination.lat, ...)
}
\arguments{
\item{p}{a datamaps object.}

\item{origin.lon, origin.lat}{origin coordinates.}

\item{destination.lon, destination.lat}{destination coordinates.}

\item{...}{any other arguments to use as options.}
}
\description{
Add arcs by coordinates.
}
\examples{
states <- data.frame(ori.lon = c(-97.03720, -87.90446),
    ori.lat = c(32.89595, 41.97960),
    des.lon = c(-106.60919, -97.66987),
    des.lat = c(35.04022, 30.19453),
    strokeColor = c("blue", "red"),
    arcSharpness = c(2, 1))

states \%>\%
    datamaps(scope = "USA", default = "lightgray") \%>\%
    add_arcs(ori.lon, ori.lat, des.lon, des.lat, strokeColor)

}
