% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{update_choropleth}
\alias{update_choropleth}
\title{Dynamically add bubbles}
\usage{
update_choropleth(proxy, locations, color, reset = FALSE, ...)
}
\arguments{
\item{proxy}{a proxy as returned by \code{\link{datamapsProxy}}.}

\item{locations}{column containing location names as \code{iso3c}.}

\item{color}{column containing color of each \code{location}.}

\item{reset}{reset previous changes to \code{default} color from \code{\link{datamaps}}.}

\item{...}{any other variable to use for tooltip.}
}
\description{
Dynamically add bubbles using Shiny.
}
\examples{
\dontrun{
library(shiny)

ui <- fluidPage(
  selectInput(
    "countrySelect",
    "Select Country",
    choices = c("USA", "FRA", "CHN", "RUS", "COG", "DZA", "BRA", "IND")
  ),
  sliderInput(
    "value",
    "Value",
    min = 1,
    max = 10,
    value = 5
  ),
  actionButton("update", "Update"),
  datamapsOutput("map")
)

server <- function(input, output){

  data <- data.frame(name = c("USA", "FRA", "CHN", "RUS", "COG", "DZA", "BRA", "IND", "ALG", "AFG"),
                     color = 1:10)

 updated_data <- reactive({
   data.frame(name = input$countrySelect, value = input$value)
 })

  output$map <- renderDatamaps({
    data \%>\%
      datamaps() \%>\%
      add_choropleth(name, color)
  })

  observeEvent(input$update, {
    datamapsProxy("map") \%>\%
      add_data(updated_data()) \%>\% # pass updated data
      update_choropleth(name, value, TRUE) # update
  })
}

shinyApp(ui, server)
}

}
