% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lackinfo.int}
\alias{lackinfo.int}
\title{Lack of information questionnaire interval dataset.}
\format{
A data frame with 50 observations of the following 8 variables:
\itemize{
    \item \code{id}: identification number.
    \item \code{sex}: sex of the respondent (\code{male} or \code{female}).
    \item \code{age}: respondent's age (in years).
    \item \code{item1}: respondent's interval-valued answer to item 1.
    \item \code{item2}: respondent's interval-valued answer to item 2.
    \item \code{item3}: respondent's interval-valued answer to item 3.
    \item \code{item4}: respondent's interval-valued answer to item 4.
    \item \code{item5}: respondent's interval-valued answer to item 5.
}
}
\source{
\url{https://CRAN.R-project.org/package=IntervalQuestionStat}
}
\usage{
data(lackinfo.int)
}
\description{
Lack of information questionnaire interval dataset generated from lackinfo dataset.
A dataset containing some biographical data and the responses
to 5 items measuring the perception of lack of information in
a questionnaire.
}
\details{
An educational innovation project was carried out for improving
teaching-learning processes at the University of Oviedo (Spain)
for the 2020/2021 academic year. A total of 50 students have been
requested to answer an online questionnaire about some biographical
data (sex and age) and their perception of lack of information by selecting the
interval that best represents their level of agreement to the
statements proposed in a interval-valued scale bounded between 1 and 7,
where 1 represents the option 'strongly disagree' and 7 represents the option
'strongly agree'.

These are the 5 items used to measure the perception of lack of information:
\itemize{
    \item I1: I receive too little information from my classmates.
    \item I2: It is difficult to receive relevant information from my classmates.
    \item I3: It is difficult to receive relevant information from the teacher.
    \item I4: The amount of information I receive from my classmates is very low.
    \item I5: The amount of information I receive from the teacher is very low.
}
}
\examples{
data(lackinfo.int)
}
\keyword{datasets}
