% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructNWISURL.R
\name{constructWQPURL}
\alias{constructWQPURL}
\title{Construct WQP url for data retrieval}
\usage{
constructWQPURL(siteNumbers, parameterCd, startDate, endDate, legacy = TRUE)
}
\arguments{
\item{siteNumbers}{string or vector of strings USGS site number.}

\item{parameterCd}{string or vector of USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the earliest possible record.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the latest possible record.}

\item{legacy}{Logical. If TRUE, uses legacy WQP services. Default is TRUE.
Setting legacy = FALSE uses WQX3.0 WQP services, which are in-development, use with caution.}
}
\value{
url string
}
\description{
Construct WQP url for data retrieval. This function gets the data from here: \url{https://www.waterqualitydata.us}
}
\examples{
site_ids <- c("USGS-02292010", "USGS-02276877")
startDate <- "2020-01-01"
endDate <- ""
pCode <- c("80154", "00613")
url_wqp <- constructWQPURL(
  site_ids,
  pCode,
  startDate, endDate
)
url_wqp
charNames <- c(
  "Temperature",
  "Temperature, sample",
  "Temperature, water",
  "Temperature, water, deg F"
)
obs_url_orig <- constructWQPURL(
  siteNumbers = c(
    "IIDFG-41WSSPAHS",
    "USGS-02352560"
  ),
  parameterCd = charNames,
  startDate, ""
)
obs_url_orig
}
\keyword{WQP}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}
