% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data360.R
\name{get_data360}
\alias{get_data360}
\title{Get TC/Govdata360 data from API}
\usage{
get_data360(site = "tc", indicator_id = NULL, dataset_id = NULL,
  country_iso3 = NULL, timeframes = NULL, output_type = "wide")
}
\arguments{
\item{site}{string pertaining to the data360 site to download data from.
Possible choices: 'tc' for TCdata360, 'gov' for Govdata360}

\item{indicator_id}{NULL (optional); Vector of indicators codes.
Should be left NULL if \code{dataset_id} is not NULL.}

\item{dataset_id}{NULL (optional); Character vector of Dataset IDs for all indicator data is to be downloaded.
Should be left NULL if \code{indicator_id} is not NULL.}

\item{country_iso3}{defaults to c('USA', 'PNG', 'PHL') (optional); Vector of countries (ISO-3 3-letter character codes,
 e.g. 'PNG', 'USA', 'PHL') for which the data is needed.
Leaving this NULL pulls data for every available country.}

\item{timeframes}{NULL (optional); Vector of years to restrict results data to.
Leaving this NULL gets all available timeframes.
Important note: \code{timeframes} parameter cannot be non-NULL while the other parameters are NULL, since data request is too large.}

\item{output_type}{string pertaining to the output type. Possible choices include:
'wide' == one row contains multi-year observations
'long' == one row refers to one year only.}
}
\value{
Data frame containing requested data
}
\description{
Downloads the requested data by using the TCdata360 API at \url{tcdata360.worldbank.org/docs}
or Govdata360 API at \url{govdata360.worldbank.org/docs}.
The function generates a data frame (wide or long, depending on user input).
}
\details{
Hint: Don't know what codes to write as inputs for this function? Helpful functions include:
\itemize{
  \item See \code{\link{search_360}} to get search TC/Govdata360 indicators, countries, categories, and dataset lists.
  \item See \code{\link{get_metadata360}} to get indicator/dataset/country-level metadata.
  \item See \code{\link{get_resources360}} to get additional resource information.
}
}
\examples{
##examples that take > 5 sec to run are not run for examples using "dontrun"
#get data for dataset ID 51 in TCdata360
\dontrun{df <- get_data360(dataset_id = 51)}

#get data for countries USA, PHL in Govdata360
\dontrun{df2 <- get_data360(site = 'gov', country_iso3 = c('USA', 'PHL'))}

#get data for indicator IDs 944, 972 in TCdata360
\dontrun{df3 <- get_data360(indicator_id = c(944, 972))}

#get data for indicator IDs 944, 972 in 2011-2013 in long format in TCdata360
\dontrun{df4 <- get_data360(indicator_id = c(944, 972), timeframes = c(2011, 2012),
output_type = 'long')}
}
