% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/node_methods.R
\name{ClimbByAttribute}
\alias{ClimbByAttribute}
\title{Find a \code{Node} by provided criteria.}
\usage{
ClimbByAttribute(node, ..., recursive = FALSE)
}
\arguments{
\item{node}{The root node of the tree or subtree to climb}

\item{...}{an attribute name to searched value pairlist. For brevity, you can also provide a character vector.}

\item{recursive}{If TRUE, then}
}
\value{
the \code{Node} having path \code{...}, or \code{NULL} if such a path does not exist
}
\description{
This method lets you climb the tree, from crutch to crutch. On each \code{Node}, the
\code{Climb} finds the first child having attribute value equal to the the provided argument.
}
\examples{
data(acme)

Aggregate(acme, attribute = "cost", aggFun = max, cacheAttribute = "cost")
ClimbByAttribute(acme, cost = function(x) x$parent$cost, recursive = TRUE)
}
\seealso{
\code{\link{Node}}

#
}

