% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.data_table_threads_benchmark.R
\name{plot.data_table_threads_benchmark}
\alias{plot.data_table_threads_benchmark}
\title{Function to make speedup plots for the benchmarked \code{data.table} functions}
\usage{
\method{plot}{data_table_threads_benchmark}(x, ...)
}
\arguments{
\item{x}{A \code{data.table} of class \code{data_table_threads_benchmark} containing benchmarked timings with corresponding thread counts.}

\item{...}{Additional arguments (not used in this function but included for consistency with the S3 generic \code{plot} function).}
}
\value{
A \code{ggplot} object containing a speedup plot for each benchmarked \code{data.table} function.
}
\description{
Function to make speedup plots for the benchmarked \code{data.table} functions
}
\details{
Creates a comprehensive \code{ggplot} showing the ideal, sub-optimal, and measured speedup trends for the \code{data.table} functions benchmarked with varying thread counts.
}
\examples{
# Finding the best performing thread count for each benchmarked data.table function
# with a data size of 1000 rows and 10 columns:
benchmarkData <- data.table.threads::findOptimalThreadCount(1e3, 10)
# Generating speedup plots based on the data collected above:
plot(benchmarkData)
}
