% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutar.R
\name{mutar}
\alias{mutar}
\alias{filtar}
\alias{sumar}
\title{Tools for Data Frames}
\usage{
mutar(x, i, j, ..., by, sby, drop)

filtar(x, i)

sumar(x, ..., by)
}
\arguments{
\item{x}{(DataFrame | data.frame)}

\item{i}{(logical | numeric | integer | OneSidedFormula | TwoSidedFormula |
FormulaList) see the examples.}

\item{j}{(logical | character | TwoSidedFormula | FormulaList | function)
character beginning with '^' are interpreted as regular expression}

\item{...}{arbitrary number of args
\cr in \code{[} (TwoSidedFormulas)
\cr in constructor see \link[tibble]{data_frame}}

\item{by}{(character) variable names used in \link{group_by}. Using `sby`
triggers a summarise.}

\item{sby}{(character) variable names used in \link{group_by}. Using `sby`
triggers a summarise.}

\item{drop}{(ignored) never drops the class.}
}
\description{
\code{mutar} is literally the same function as \code{[.DataFrame} and can be
used as a generic interface to dplyr. Other functions here listed are a
convenience to mimic dplyr's syntax in a \code{R CMD check} friendly way.
These functions can also be used with S4 data.frame(s) / data_frame(s) /
data.table(s). They will always preserve the input class.
}
\details{
The real workhorse of this interface is \code{mutar}. All other functions
exist to ease the transition from dplyr.

\code{OneSidedFormula} is always used for subsetting rows.

\code{TwoSidedFormula} is used instead of name-value expressions in
\link[dplyr]{summarise} and \link[dplyr]{mutate}.

\code{FormulaList} can be used to repeat the same operation on different
columns.
}
\examples{
data("airquality")
airquality \%>\%
  filtar(~Month > 4) \%>\%
  mutar(meanWind ~ mean(Wind), by = "Month") \%>\%
  sumar(meanWind ~ mean(Wind), by = "Month") \%>\%
  extract("meanWind")

airquality \%>\%
  sumar(
    FL(.n ~ mean(.n), .n = c("Wind", "Temp")),
    by = "Month"
  )
}
\seealso{
\link{extract}, \link{DataFrame}, \link{FL}
}
