% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owsa.R
\name{owsa_opt_strat}
\alias{owsa_opt_strat}
\title{plot the optimal strategy as the parameter values change}
\usage{
owsa_opt_strat(
  owsa,
  params = NULL,
  maximize = TRUE,
  return = c("plot", "data"),
  plot_const = TRUE,
  col = c("full", "bw"),
  greystart = 0.2,
  greyend = 0.8,
  txtsize = 12,
  facet_ncol = 1,
  facet_nrow = NULL,
  facet_lab_txtsize = NULL,
  n_x_ticks = 10
)
}
\arguments{
\item{owsa}{An owsa object}

\item{params}{vector of parameters to plot}

\item{maximize}{whether to maximize (TRUE) or minimize the outcome}

\item{return}{either return a ggplot object \code{plot} or a data frame with
ranges of parameters for which each strategy is optimal.}

\item{plot_const}{whether to plot parameters that don't lead to
changes in optimal strategy as they vary.}

\item{col}{either none, full color, or black and white}

\item{greystart}{between 0 and 1. used in greyscale only. smaller numbers are lighter}

\item{greyend}{between 0 and 1, greater than greystart.}

\item{txtsize}{base text size}

\item{facet_ncol}{Number of columns in plot facet.}

\item{facet_nrow}{number of rows in plot facet.}

\item{facet_lab_txtsize}{text size for plot facet labels}

\item{n_x_ticks}{number of axis ticks}
}
\value{
If \code{return == "plot"}, a \code{ggplot2} optimal strategy plot derived from the \code{owsa}
object, or if \code{return == "data"}, a \code{data.frame} containing all data contained in the plot.
The plot allows us to see how the strategy that maximizes the expectation of the outcome of interest
changes as a function of each parameter of interest.
}
\description{
plot the optimal strategy as the parameter values change
}
