% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{simulateLogistic}
\alias{simulateLogistic}
\title{Simulate Binary Data from DAG Structure}
\usage{
simulateLogistic(x, b.default = NULL, b.lower = -0.6, b.upper = 0.6,
  eps = 0, N = 500, verbose = FALSE)
}
\arguments{
\item{x}{the input graph, a DAG (which may contain bidirected edges).}

\item{b.default}{default path coefficient applied to arrows for which no coefficient is 
defined in the model syntax.}

\item{b.lower}{lower bound for random path coefficients, applied if \code{b.default=NULL}.}

\item{b.upper}{upper bound for path coefficients.}

\item{eps}{base log-odds ratio.}

\item{N}{number of samples to generate.}

\item{verbose}{logical. If true, prints the order in which the data are generated (which
should be a topological order).}
}
\description{
Interprets input DAG as a structural description of a logistic
model in which each variable is binary and its log-odds ratio is 
a linear combination of its parent values.
}
