% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{graphLayout}
\alias{graphLayout}
\title{Generate Graph Layout}
\usage{
graphLayout(x, method = "spring")
}
\arguments{
\item{x}{the input graph, of any type.}

\item{method}{the layout method; currently, only \code{"spring"} is supported.}
}
\value{
the same graph as \code{x} but with layout coordinates added.
}
\description{
This function generates plot coordinates for each variable in a graph that does not
have them already. To this end, the well-known \dQuote{Spring} layout algorithm is
used. Note that this is a stochastic algorithm, so the generated layout will be 
different every time (which also means that you can try several times until you find
a decent layout).
}
\examples{
## Generate a layout for the M-bias graph and plot it
plot( graphLayout( dagitty( "dag { X <- U1 -> M <- U2 -> Y } " ) ) )

}

