% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{simulateSEM}
\alias{simulateSEM}
\title{Simulate Data from Structural Equation Model}
\usage{
simulateSEM(x, b.lower = -0.6, b.upper = 0.6, eps = 1, N = 500,
  standardized = TRUE)
}
\arguments{
\item{x}{the input graph, a DAG (which may contain bidirected edges).}

\item{b.lower}{lower bound for path coefficients.}

\item{b.upper}{upper bound for path coefficients.}

\item{eps}{residual variance (only meaningful if \code{standardized=FALSE}).}

\item{N}{number of samples to generate.}

\item{standardized}{whether a standardized output is desired (all variables have variance 1).

If \code{standardized=TRUE}, all path coefficients are interpreted as standardized coefficients.
But not all standardized coefficients are compatible with all graph structures.
For instance, the graph structure z <- x -> y -> z is incompatible with standardized
coefficients of 0.9, since this would imply that the variance of z must be larger than
1. For large graphs with many parallel paths, it can be very difficult to find coefficients 
that work.}
}
\value{
Returns a data frame containing \code{N} values for each variable in \code{x}.
}
\description{
Interprets the input graph as a structural equation model, generates random path 
coefficients, and simulates data from the model. This is just a dumb frontend to 
lavaan's \code{\link[lavaan]{simulateData}} function and probably not very useful 
except for quick validation purposes (e.g. checking that an implied vanishing 
tetrad truly vanishes in simulated data). For more elaborate simulation studies, please
use the lavaan package or similar facilities in other packages.
}
\details{
Data are generated in the following manner. 
Each directed arrow is assigned a path coefficient chosen uniformly
at random from the interval given by \code{b.lower} and \code{b.upper} (inclusive; set
both parameters to the same value for constant path coefficients). Each bidirected 
arrow a <-> b is replaced by a substructure  a <- L -> b, where L is an exogenous latent
variable. Path coefficients on such substructures are set to \code{sqrt(x)}, where 
\code{x} is again chosen at random from the given interval; if \code{x} is negative,
one path coefficient is set to \code{-sqrt(x)} and the other to \code{sqrt(x)}. All
residual variances are set to \code{eps}.
}
\examples{
## Simulate data with pre-defined path coefficients of -.6
g <- dagitty('dag{z -> x <- y}')
x <- simulateSEM( g, .707, .707 ) # sqrt(2)/2 is largest possible
cov(x)


}

