% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.clustering_part2.R
\name{rain_reclus}
\alias{rain_reclus}
\alias{plot.rain_reclus}
\title{Identification and clustering of "rain" data}
\usage{
rain_reclus(cmeans.cluster)

\method{plot}{rain_reclus}(x, ..., sample = "all")
}
\arguments{
\item{cmeans.cluster}{an object of class \code{cmeans_clus}, inherited
from \code{\link{cmeans_clus}}.}

\item{x}{an object of class \code{rain_reclus}}

\item{...}{Arguments to be passed to methods}

\item{sample}{'all' to show all samples, or a numeric vector indicating
the row number of samples in the sample table.}
}
\value{
An object of class \code{rain_reclus} containing a sublist for
  each sample. Each sublist has the following components:
  \item{quality}{quality threshold used in \code{\link{read_sample}}.}
  \item{reference}{reference ID.}
  \item{centers}{a data frame with the centroids coordinates.}
  \item{data}{a data frame with the fluorescence intensities and clusters
  name.}
}
\description{
This function identifies the "rain" elements and re-clusters them using the
Mahalanobis distance. Each "rain" element is assigned to the cluster whose
Mahalanobis distance is the lowest.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata",package = "dPCP")

#Read sample table file
sample.table <- read_sampleTable(sampleTable, system = "bio-rad",
                                 file.location = fileLoc)

#Read reference files
ref <- read_reference(sample.table, system = "bio-rad",
                      file.location = fileLoc)

#Read samples files
samp <- read_sample(sample.table, system = "bio-rad",
                   file.location = fileLoc)

#Reference DBSCAN clustering
dbref <- reference_dbscan(ref, sample.table, save.template = FALSE)

#Predict position of clusters centroid from reference DBSCAN results
cent <- centers_data(samp, sample.table,dbref)

#Fuzzy c-means clustering
cmclus <- cmeans_clus(cent)

#Rain classification.
rainclus <- rain_reclus(cmclus)

plot(rainclus, sample = "all")
}
}
